/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.layoutmanagers;

import com.ibm.cics.ia.ui.viz.layoutmanagers.SortedGraphEdge;
import com.ibm.cics.ia.ui.viz.layoutmanagers.SortedGraphNode;
import java.util.Arrays;

public class EdgeMetric
implements Comparable<EdgeMetric> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    SortedGraphEdge edge;
    int[] metrics;

    public EdgeMetric(SortedGraphEdge edge) {
        this.edge = edge;
        SortedGraphNode sourceNode = edge.getSourceNode();
        SortedGraphNode targetNode = edge.getTargetNode();
        int maxLevel = sourceNode.getLevel() < targetNode.getLevel() ? targetNode.getLevel() : sourceNode.getLevel();
        this.metrics = new int[maxLevel + 1];
        SortedGraphNode currentSource = sourceNode;
        SortedGraphNode currentTarget = targetNode;
        int currentLevel = maxLevel;
        while (currentLevel > 0) {
            int sourceIndex = currentSource.getLevel() == currentLevel ? currentSource.getIndex() : 0;
            int targetIndex = currentTarget.getLevel() == currentLevel ? currentTarget.getIndex() : 0;
            this.metrics[currentLevel] = targetIndex - sourceIndex;
            if (currentSource.getLevel() == currentLevel) {
                currentSource = currentSource.getParent();
            }
            if (currentTarget.getLevel() == currentLevel) {
                currentTarget = currentTarget.getParent();
            }
            --currentLevel;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.edge == null ? 0 : this.edge.hashCode());
        result = 31 * result + Arrays.hashCode(this.metrics);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EdgeMetric other = (EdgeMetric)obj;
        if (this.edge == null ? other.edge != null : !this.edge.equals(other.edge)) {
            return false;
        }
        return Arrays.equals(this.metrics, other.metrics);
    }

    @Override
    public int compareTo(EdgeMetric o) {
        if (this.equals(o)) {
            return 0;
        }
        int maxLevel = this.metrics.length < o.metrics.length ? this.metrics.length : o.metrics.length;
        int i = 0;
        while (i < maxLevel) {
            if (this.metrics[i] < o.metrics[i]) {
                return -1;
            }
            if (o.metrics[i] < this.metrics[i]) {
                return 1;
            }
            ++i;
        }
        return 0;
    }
}

