/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.figures;

import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.viz.figures.GridFigure;
import com.ibm.cics.ia.ui.viz.figures.IFigureResizeListener;
import com.ibm.cics.ia.ui.viz.figures.ISizeChangingFigure;
import com.ibm.cics.ia.ui.viz.figures.TitledContainerFigure;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Button;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.widgets.Display;

public class TitledExpandableFigure
extends TitledContainerFigure {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected boolean expanded = false;
    protected Button expandButton;
    protected Dimension collapsedSize;
    protected Dimension expandedSize;

    public TitledExpandableFigure(int margin) {
        this((IFigure)new Figure(), margin);
    }

    public TitledExpandableFigure(IFigure titleFigure) {
        this(titleFigure, 10);
    }

    public TitledExpandableFigure(IFigure titleFigure, int margin) {
        super(margin);
        TitledExpandableFigure focusFigure = this;
        this.expandButton = new Button(ImageFactory.getExpandSingleImage());
        this.expandButton.setStyle(Clickable.STYLE_TOGGLE);
        this.expandButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TitledExpandableFigure.this.expanded = !TitledExpandableFigure.this.expanded;
                TitledExpandableFigure.this.figureResized();
                TitledExpandableFigure.this.updateFigureIcon();
            }
        });
        this.expandButton.setFont(this.getFont());
        this.expandButton.setFocusTraversable(false);
        this.add((IFigure)this.expandButton, new Rectangle(this.getExpandButtonLocation(), this.expandButton.getPreferredSize()));
        this.setTitleFigure(titleFigure);
        this.collapsedSize = this.getCollapsedSize();
        this.expandedSize = this.getExpandedSize();
        this.calculateSize();
    }

    @Override
    public void setTitleFigure(IFigure newFigure) {
        super.setTitleFigure(newFigure);
        Rectangle constraint = ((Rectangle)this.getLayoutManager().getConstraint((IFigure)this.expandButton)).getCopy();
        constraint.setLocation(this.getExpandButtonLocation());
        this.getLayoutManager().setConstraint((IFigure)this.expandButton, (Object)constraint);
        if (newFigure instanceof ISizeChangingFigure) {
            ((ISizeChangingFigure)newFigure).addResizeListener(this);
        }
    }

    protected void setContent(GridFigure figure) {
        super.setContent((IFigure)figure);
        this.expandedSize = this.getExpandedSize();
        Rectangle bounds = this.getBounds().getCopy();
        bounds.width = this.expandedSize.width;
        bounds.height = this.expandedSize.height;
        IFigure parent = this.getParent();
        if (parent != null) {
            LayoutManager mgr = parent.getLayoutManager();
            mgr.setConstraint((IFigure)this, (Object)bounds);
        }
        this.calculateSize();
        figure.setVisible(this.expanded);
    }

    private void updateFigureIcon() {
        if (this.expandButton != null) {
            if (this.expanded) {
                ((Label)this.expandButton.getChildren().get(0)).setIcon(ImageFactory.getCollapseSingleImage());
            } else {
                ((Label)this.expandButton.getChildren().get(0)).setIcon(ImageFactory.getExpandSingleImage());
            }
        }
    }

    @Override
    protected void figureResized() {
        IFigure parent;
        Dimension size = this.calculateSize();
        Rectangle bounds = this.getBounds().getCopy();
        bounds.setSize(size);
        this.setBounds(bounds);
        if (this.expandButton != null) {
            Rectangle buttonConstraint = ((Rectangle)this.getLayoutManager().getConstraint((IFigure)this.expandButton)).getCopy();
            buttonConstraint.setLocation(this.getExpandButtonLocation());
            this.getLayoutManager().setConstraint((IFigure)this.expandButton, (Object)buttonConstraint);
        }
        if (this.contentFigure != null) {
            this.contentFigure.setVisible(this.expanded);
            Point contentLoc = this.getContentLocation();
            Rectangle contentBounds = new Rectangle(contentLoc, this.contentFigure.getPreferredSize());
            this.getLayoutManager().setConstraint(this.contentFigure, (Object)contentBounds);
        }
        if ((parent = this.getParent()) != null) {
            LayoutManager mgr = parent.getLayoutManager();
            if (mgr != null && mgr.getConstraint((IFigure)this) != null) {
                Rectangle constraint = ((Rectangle)mgr.getConstraint((IFigure)this)).getCopy();
                constraint.setSize(this.getPreferredSize());
                mgr.setConstraint((IFigure)this, (Object)constraint);
            }
            for (IFigureResizeListener listener : this.figureResizeListeners) {
                listener.onFigureResized(this);
            }
        }
    }

    protected Point getExpandButtonLocation() {
        Point result = new Point();
        Dimension size = this.expanded ? this.getExpandedSize() : this.getCollapsedSize();
        result.x = size.width - this.margin - this.expandButton.getPreferredSize().width;
        result.y = this.margin;
        return result;
    }

    protected Dimension getCollapsedSize() {
        Dimension result = new Dimension();
        int buttonHeight = 0;
        int titleHeight = 0;
        if (this.titleFigure != null) {
            result.width = this.margin + this.titleFigure.getPreferredSize().width;
            titleHeight = this.titleFigure.getPreferredSize().height;
        }
        if (this.expandButton != null) {
            result.width += this.margin + this.expandButton.getPreferredSize().width;
            buttonHeight = this.expandButton.getPreferredSize().height;
        }
        result.width += this.margin;
        result.height = this.margin + (titleHeight > buttonHeight ? titleHeight : buttonHeight) + this.margin;
        return result;
    }

    protected Dimension getExpandedSize() {
        Dimension result = this.getCollapsedSize();
        if (this.contentFigure != null) {
            if (this.margin + this.contentFigure.getPreferredSize().width + this.margin > result.width) {
                result.width = this.margin + this.contentFigure.getPreferredSize().width + this.margin;
            }
            result.height = result.height + this.contentFigure.getPreferredSize().height + this.margin;
        }
        return result;
    }

    @Override
    protected Point getContentLocation() {
        int posX = this.margin;
        int titleHeight = this.titleFigure.getPreferredSize().height;
        int buttonHeight = this.expandButton.getPreferredSize().height;
        int posY = this.margin + (titleHeight > buttonHeight ? titleHeight : buttonHeight) + this.margin;
        return new Point(posX, posY);
    }

    @Override
    protected Dimension calculateSize() {
        if (this.expanded) {
            Dimension result = this.getExpandedSize();
            this.setPreferredSize(result);
            this.setMaximumSize(result);
            this.setMinimumSize(result);
            return result;
        }
        Dimension result = this.getCollapsedSize();
        this.setPreferredSize(result);
        this.setMaximumSize(result);
        this.setMinimumSize(result);
        return result;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
        this.expandButton.setSelected(expanded);
        this.figureResized();
        this.updateFigureIcon();
    }

    public boolean isExpnaded() {
        return this.expanded;
    }

    public boolean isButtonFocused() {
        return this.expandButton.hasFocus();
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setAntialias(1);
        Rectangle r = this.getBounds();
        Rectangle patternRec = r.getCopy();
        this.translateToAbsolute((Translatable)patternRec);
        if (this.selected) {
            graphics.setBackgroundPattern(new Pattern((Device)Display.getCurrent(), (float)(patternRec.x + patternRec.width / 2), (float)r.y, (float)(patternRec.x + patternRec.width / 2), (float)(r.y + patternRec.height), this.backgroundColor1Selected, this.backgroundColor2Selected));
        } else {
            graphics.setBackgroundPattern(new Pattern((Device)Display.getCurrent(), (float)(patternRec.x + patternRec.width / 2), (float)r.y, (float)(patternRec.x + patternRec.width / 2), (float)(r.y + patternRec.height), this.backgroundColor1Deselected, this.backgroundColor2Deselected));
        }
        graphics.fillRoundRectangle(new Rectangle(r.x + 1, r.y + 1, r.width - 4, r.height - 4), 5, 5);
        if (this.selected) {
            graphics.setLineWidth(2);
            graphics.setForegroundColor(this.borderColorSelected);
        } else {
            graphics.setLineWidth(1);
            graphics.setForegroundColor(this.borderColorDeselected);
        }
        graphics.setAlpha(64);
        graphics.drawRoundRectangle(new Rectangle(r.x + 1, r.y + 1, r.width - 2, r.height - 2), 7, 7);
        graphics.setAlpha(128);
        graphics.drawRoundRectangle(new Rectangle(r.x + 1, r.y + 1, r.width - 3, r.height - 3), 6, 6);
        graphics.setForegroundColor(this.textColor);
        super.paint(graphics);
    }
}

