/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.figures;

import com.ibm.cics.ia.ui.UIUtilities;
import com.ibm.cics.ia.ui.viz.FontFactory;
import com.ibm.cics.ia.ui.viz.figures.Messages;
import com.ibm.cics.ia.ui.viz.layoutmanagers.TimelineGraphLayoutManager;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.graphics.Color;

public class TimelineFigure
extends Figure {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private TimelineGraphLayoutManager layoutManager;
    private String timelineColumnName = "TimelineFigure.Column.TCB";
    public static final String TCB_SWTICHES_COLUMN = "TimelineFigure.Column.TCB";
    public static final String REGION_SWTICHES_COLUMN = "TimelineFigure.Column.Region";

    public void setTimelineColumnName(String columnName) {
        this.timelineColumnName = columnName;
    }

    public void setBounds(Rectangle rect) {
        boolean translate;
        int x = this.bounds.x;
        int y = this.bounds.y;
        boolean resize = rect.width != this.bounds.width || rect.height != this.bounds.height;
        boolean bl = translate = rect.x != x || rect.y != y;
        if (this.isVisible() && (resize || translate)) {
            this.erase();
        }
        if (translate) {
            int dx = rect.x - x;
            int dy = rect.y - y;
            this.primTranslate(dx, dy);
        }
        this.bounds.width = rect.width;
        this.bounds.height = rect.height;
        if (resize || translate) {
            this.fireFigureMoved();
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        graphics.setAntialias(1);
        Rectangle r = this.getBounds();
        Rectangle patternRec = r.getCopy();
        patternRec.setWidth(patternRec.width - 1);
        patternRec.setHeight(patternRec.height - 1);
        this.translateToAbsolute((Translatable)patternRec);
        Rectangle headerRect = this.layoutManager.getRowRectangle(0);
        graphics.setFont(FontFactory.getInstance().getBoldFont());
        int rowCount = this.layoutManager.getRowCount();
        int i = 0;
        while (i < rowCount) {
            if (i % 2 == 1) {
                graphics.setBackgroundColor(new Color(null, 220, 220, 220));
                graphics.setAlpha(32);
            } else {
                graphics.setBackgroundColor(new Color(null, 255, 255, 255));
                graphics.setAlpha(255);
            }
            Rectangle rowRect = this.layoutManager.getRowRectangle(i);
            graphics.fillRectangle(rowRect);
            graphics.setAlpha(128);
            graphics.setForegroundColor(new Color(null, 128, 128, 128));
            switch (this.layoutManager.getDirection()) {
                case 16: {
                    graphics.drawLine(new Point(rowRect.getBottomLeft().x, rowRect.getBottomLeft().y - 1), new Point(rowRect.getBottomRight().x, rowRect.getBottomRight().y - 1));
                    graphics.setAlpha(255);
                    graphics.setForegroundColor(new Color(null, 64, 64, 64));
                    graphics.drawText(this.layoutManager.getTimelineObject(i).toString(), new Point(rowRect.getLeft().x + 10, rowRect.getCenter().y));
                    break;
                }
                case 4: {
                    if (i > 0) {
                        graphics.drawLine(new Point(rowRect.getTopLeft().x, rowRect.getTopLeft().y - 1), new Point(rowRect.getBottomLeft().x, rowRect.getBottomLeft().y - 1));
                    }
                    graphics.setAlpha(255);
                    graphics.setForegroundColor(new Color(null, 64, 64, 64));
                    int pixelLength = UIUtilities.getPixelLength(this.layoutManager.getTimelineObject(i).toString(), graphics.getFont());
                    graphics.drawText(this.layoutManager.getTimelineObject(i).toString(), new Point(rowRect.x + (rowRect.width - pixelLength) / 2, 20));
                }
            }
            ++i;
        }
        if (this.timelineColumnName != null) {
            switch (this.layoutManager.getDirection()) {
                case 16: {
                    graphics.drawText(Messages.getString(this.timelineColumnName), new Point(headerRect.getLeft().x + 10, headerRect.getTop().y - 13));
                    break;
                }
                case 4: {
                    graphics.drawText(Messages.getString(this.timelineColumnName), new Point(7, 20));
                }
            }
        }
        graphics.setBackgroundColor(new Color(null, 255, 255, 255));
        graphics.setAlpha(255);
        graphics.setFont(FontFactory.getInstance().getDefaultFont());
        super.paint(graphics);
    }

    public void setLayoutManager(TimelineGraphLayoutManager layoutManager) {
        this.layoutManager = layoutManager;
        super.setLayoutManager((LayoutManager)layoutManager);
    }
}

