/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.figures;

import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.viz.NodeConnection;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.ResourceRenderer;
import com.ibm.cics.ia.ui.ResourceTypeRenderer;
import com.ibm.cics.ia.ui.viz.TypeColorFactory;
import com.ibm.cics.ia.ui.viz.figures.ConnectionFigure;
import com.ibm.cics.ia.ui.viz.figures.TooltipFigure;
import java.util.ArrayList;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.swt.graphics.Color;

public class ResourceConnectionFigure
extends ConnectionFigure {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private NodeConnection resourceNodeConnection;

    public ResourceConnectionFigure(NodeConnection resourceNodeConnection) {
        this.resourceNodeConnection = resourceNodeConnection;
        String name = this.getName();
        if (!IAUtilities.EMPTY_STRING.equals(name)) {
            TooltipFigure tooltipFigure = new TooltipFigure();
            tooltipFigure.setMessage(name);
            this.setToolTip((IFigure)tooltipFigure);
        }
        this.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
        this.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        this.setForegroundColor(this.getColor());
    }

    public String getName() {
        StringBuilder verbNames = new StringBuilder();
        ArrayList verbs = this.resourceNodeConnection.getVerbs();
        String sourceName = IAUtilities.EMPTY_STRING;
        String targetName = IAUtilities.EMPTY_STRING;
        sourceName = String.valueOf(ResourceTypeRenderer.asText(((Resource)this.resourceNodeConnection.getSource().getObject()).getTypeName())) + " (" + ResourceRenderer.asText((Resource)this.resourceNodeConnection.getSource().getObject()) + ") ";
        targetName = " " + ResourceTypeRenderer.asText(((Resource)this.resourceNodeConnection.getTarget().getObject()).getTypeName()) + " (" + ResourceRenderer.asText((Resource)this.resourceNodeConnection.getTarget().getObject()) + ") ";
        for (String verb : verbs) {
            if (!IAUtilities.hasContent((String)verb)) continue;
            verbNames.append(String.valueOf(verb) + ", ");
        }
        if (verbNames.length() >= 2) {
            verbNames.setLength(verbNames.length() - 2);
        }
        if (verbNames.length() > 0) {
            return String.valueOf(sourceName) + verbNames.toString() + targetName;
        }
        return IAUtilities.EMPTY_STRING;
    }

    public Color getColor() {
        Color result = ColorConstants.darkGray;
        Resource target = (Resource)this.resourceNodeConnection.getTarget().getObject();
        boolean highSat = true;
        if (this.resourceNodeConnection.getVerbs().size() == 1 && "".equals(this.resourceNodeConnection.getVerbs().get(0))) {
            highSat = false;
        }
        result = TypeColorFactory.getColor(target, highSat);
        return result;
    }
}

