/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.figures;

import com.ibm.cics.ia.ui.viz.figures.IFigureResizeListener;
import com.ibm.cics.ia.ui.viz.figures.ISizeChangingFigure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class GridFigure
extends Figure
implements ISizeChangingFigure,
IFigureResizeListener {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected int margin;
    protected static final int DEFAULT_MARGIN = 10;
    protected int spacing;
    protected static final int DEFAULT_SPACING = 10;
    private int columnCount = 1;
    private int childrenCount;
    protected ArrayList<IFigureResizeListener> figureResizeListeners = new ArrayList();
    private HashMap<Object, Object> data = new HashMap();
    ArrayList<IFigure>[] children;

    public GridFigure() {
        this(1, 10, 10);
    }

    public GridFigure(int columnCount, int margin, int spacing) {
        this.columnCount = columnCount;
        this.margin = margin;
        this.spacing = spacing;
        XYLayout containerLayout = new XYLayout();
        this.setLayoutManager((LayoutManager)containerLayout);
        this.children = new ArrayList[columnCount];
        int i = 0;
        while (i < columnCount) {
            this.children[i] = new ArrayList();
            ++i;
        }
        this.childrenCount = 0;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        Dimension size = this.getPreferredSize();
        LayoutManager mgr = this.getParent().getLayoutManager();
        Rectangle constraint = ((Rectangle)mgr.getConstraint((IFigure)this)).getCopy();
        constraint.setSize(size);
        mgr.setConstraint((IFigure)this, (Object)constraint);
        List figures = this.getChildren();
        for (IFigure figure : figures) {
            figure.setVisible(visible);
            figure.repaint();
        }
        this.repaint();
    }

    public void figureResized() {
        int rowCount = this.childrenCount / this.columnCount + 1;
        int currentColumnCount = this.columnCount;
        if (this.childrenCount < this.columnCount) {
            currentColumnCount = this.childrenCount;
        }
        int[] maxColumnWidths = new int[currentColumnCount];
        int[] maxRowHeights = new int[rowCount];
        int[] columnStarts = new int[currentColumnCount];
        int[] rowStarts = new int[rowCount];
        int i = 0;
        while (i < currentColumnCount) {
            maxColumnWidths[i] = 0;
            columnStarts[i] = 0;
            ++i;
        }
        i = 0;
        while (i < rowCount) {
            maxRowHeights[i] = 0;
            rowStarts[i] = 0;
            ++i;
        }
        i = 0;
        while (i < currentColumnCount) {
            int j = 0;
            while (j < rowCount) {
                if (this.children[i].size() > j) {
                    IFigure figure = this.children[i].get(j);
                    int width = figure.getPreferredSize().width;
                    int height = figure.getPreferredSize().height;
                    if (width > maxColumnWidths[i]) {
                        maxColumnWidths[i] = width;
                    }
                    if (height > maxRowHeights[j]) {
                        maxRowHeights[j] = height;
                    }
                }
                ++j;
            }
            ++i;
        }
        columnStarts[0] = this.spacing;
        rowStarts[0] = this.spacing;
        i = 1;
        while (i < currentColumnCount) {
            columnStarts[i] = columnStarts[i - 1] + maxColumnWidths[i - 1] + this.margin;
            ++i;
        }
        i = 1;
        while (i < rowCount) {
            rowStarts[i] = rowStarts[i - 1] + maxRowHeights[i - 1] + this.margin;
            ++i;
        }
        LayoutManager mgr = this.getLayoutManager();
        int i2 = 0;
        while (i2 < currentColumnCount) {
            int j = 0;
            while (j < rowCount) {
                if (this.children[i2].size() > j) {
                    IFigure figure = this.children[i2].get(j);
                    Rectangle oldConstraint = (Rectangle)mgr.getConstraint(figure);
                    Rectangle newConstraint = new Rectangle(new Point(columnStarts[i2], rowStarts[j]), figure.getPreferredSize());
                    mgr.setConstraint(figure, (Object)newConstraint);
                }
                ++j;
            }
            ++i2;
        }
        int width = columnStarts[currentColumnCount - 1] + maxColumnWidths[currentColumnCount - 1] + this.spacing;
        int height = rowStarts[rowCount - 1] + maxRowHeights[rowCount - 1] + this.spacing;
        Dimension size = new Dimension(width, height);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        Rectangle bounds = this.getBounds().getCopy();
        bounds.setSize(size);
        this.setBounds(bounds);
        IFigure parent = this.getParent();
        if (parent != null && (mgr = parent.getLayoutManager()) != null && mgr.getConstraint((IFigure)this) != null) {
            Rectangle constraint = ((Rectangle)mgr.getConstraint((IFigure)this)).getCopy();
            constraint.setSize(this.getPreferredSize());
            mgr.setConstraint((IFigure)this, (Object)constraint);
        }
        for (IFigureResizeListener listener : this.figureResizeListeners) {
            listener.onFigureResized(this);
        }
    }

    private void childAdded(IFigure childFigure) {
        IFigure parent;
        int height;
        int width;
        int childColumn = this.childrenCount % this.columnCount;
        int rowCount = this.childrenCount / this.columnCount + 1;
        ++this.childrenCount;
        int currentColumnCount = this.columnCount;
        if (this.childrenCount < this.columnCount) {
            currentColumnCount = this.childrenCount;
        }
        this.children[childColumn].add(childFigure);
        int[] maxColumnWidths = new int[currentColumnCount];
        int[] maxRowHeights = new int[rowCount];
        int[] columnStarts = new int[currentColumnCount];
        int[] rowStarts = new int[rowCount];
        int i = 0;
        while (i < currentColumnCount) {
            maxColumnWidths[i] = 0;
            columnStarts[i] = 0;
            ++i;
        }
        i = 0;
        while (i < rowCount) {
            maxRowHeights[i] = 0;
            rowStarts[i] = 0;
            ++i;
        }
        i = 0;
        while (i < currentColumnCount) {
            int j = 0;
            while (j < rowCount) {
                if (this.children[i].size() > j) {
                    IFigure figure = this.children[i].get(j);
                    width = figure.getPreferredSize().width;
                    height = figure.getPreferredSize().height;
                    if (width > maxColumnWidths[i]) {
                        maxColumnWidths[i] = width;
                    }
                    if (height > maxRowHeights[j]) {
                        maxRowHeights[j] = height;
                    }
                }
                ++j;
            }
            ++i;
        }
        columnStarts[0] = this.spacing;
        rowStarts[0] = this.spacing;
        i = 1;
        while (i < currentColumnCount) {
            columnStarts[i] = columnStarts[i - 1] + maxColumnWidths[i - 1] + this.margin;
            ++i;
        }
        i = 1;
        while (i < rowCount) {
            rowStarts[i] = rowStarts[i - 1] + maxRowHeights[i - 1] + this.margin;
            ++i;
        }
        int xPos = columnStarts[childColumn];
        int yPos = rowStarts[rowCount - 1];
        LayoutManager mgr = this.getLayoutManager();
        mgr.setConstraint(childFigure, (Object)new Rectangle(new Point(xPos, yPos), childFigure.getPreferredSize()));
        int i2 = 0;
        while (i2 < currentColumnCount) {
            int j = 0;
            while (j < rowCount - 1) {
                IFigure figure = this.children[i2].get(j);
                Rectangle oldConstraint = (Rectangle)mgr.getConstraint(figure);
                Rectangle newConstraint = new Rectangle(new Point(columnStarts[i2], rowStarts[j]), figure.getPreferredSize());
                mgr.setConstraint(figure, (Object)newConstraint);
                ++j;
            }
            ++i2;
        }
        width = columnStarts[currentColumnCount - 1] + maxColumnWidths[currentColumnCount - 1] + this.spacing;
        height = rowStarts[rowCount - 1] + maxRowHeights[rowCount - 1] + this.spacing;
        Dimension size = new Dimension(width, height);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        Rectangle bounds = this.getBounds().getCopy();
        bounds.setSize(size);
        this.setBounds(bounds);
        if (childFigure instanceof ISizeChangingFigure) {
            ((ISizeChangingFigure)childFigure).addResizeListener(this);
        }
        if ((parent = this.getParent()) != null && (mgr = parent.getLayoutManager()) != null && mgr.getConstraint((IFigure)this) != null) {
            Rectangle constraint = ((Rectangle)mgr.getConstraint((IFigure)this)).getCopy();
            constraint.setSize(this.getPreferredSize());
            mgr.setConstraint((IFigure)this, (Object)constraint);
        }
        for (IFigureResizeListener listener : this.figureResizeListeners) {
            listener.onFigureResized(this);
        }
    }

    public void setData(Object value) {
        this.data.put(null, value);
    }

    public void setData(Object key, Object value) {
        this.data.put(key, value);
    }

    public Object getData() {
        return this.data.get(null);
    }

    public Object getData(Object key) {
        return this.data.get(key);
    }

    @Override
    public void addResizeListener(IFigureResizeListener listener) {
        this.figureResizeListeners.add(listener);
    }

    @Override
    public void removeResizeListener(IFigureResizeListener listener) {
        this.figureResizeListeners.remove(listener);
    }

    @Override
    public void onFigureResized(ISizeChangingFigure resizedFigure) {
        this.figureResized();
    }

    public void add(IFigure figure, Object constraint, int index) {
        super.add(figure, constraint, index);
        this.childAdded(figure);
    }
}

