/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.figures;

import com.ibm.cics.ia.model.CommandExecution;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourceAndVerb;
import com.ibm.cics.ia.model.viz.CommandNode;
import com.ibm.cics.ia.model.viz.INode;
import com.ibm.cics.ia.ui.ResourceRenderer;
import com.ibm.cics.ia.ui.viz.FontFactory;
import com.ibm.cics.ia.ui.viz.TypeColorFactory;
import com.ibm.cics.ia.ui.viz.figures.ISelectableFigure;
import com.ibm.cics.ia.ui.viz.figures.Messages;
import com.ibm.cics.ia.ui.viz.figures.TitledImageFigure;
import com.ibm.cics.ia.ui.viz.figures.TooltipFigure;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.widgets.Display;

public class CommandFigure
extends Figure
implements ISelectableFigure {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Color textColor = DEFAULT_TEXT_COLOR;
    protected Color borderColorSelected = DEFAULT_BORDER_COLOR_SELECTED;
    protected Color borderColorDeselected = DEFAULT_BORDER_COLOR_DESELECTED;
    protected Color backgroundColor1Deselected = DEFAULT_BACKGROUND_COLOR_1_DESELECTED;
    protected Color backgroundColor2Deselected = DEFAULT_BACKGROUND_COLOR_2_DESELECTED;
    protected Color backgroundColor1Selected = DEFAULT_BACKGROUND_COLOR_1_SELECTED;
    protected Color backgroundColor2Selected = DEFAULT_BACKGROUND_COLOR_2_SELECTED;
    protected static Color DEFAULT_TEXT_COLOR = ColorConstants.black;
    protected static Color DEFAULT_BORDER_COLOR_DESELECTED = ColorConstants.gray;
    protected static Color DEFAULT_BORDER_COLOR_SELECTED = ColorConstants.darkGray;
    protected static Color DEFAULT_BACKGROUND_COLOR_1_DESELECTED = ColorConstants.white;
    protected static Color DEFAULT_BACKGROUND_COLOR_2_DESELECTED = new Color(null, 230, 230, 230);
    protected static Color DEFAULT_BACKGROUND_COLOR_1_SELECTED = ColorConstants.white;
    protected static Color DEFAULT_BACKGROUND_COLOR_2_SELECTED = new Color(null, 210, 210, 210);
    protected INode resourceNode;
    protected int margin;
    public static final int DEFAULT_MARGIN = 6;
    protected int maxLength;
    public static final int DEFAULT_MAX_LENGTH = 32;
    protected TitledImageFigure titleFigure;
    private static DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");
    protected boolean selected;

    public CommandFigure(INode resourceNode) {
        this(resourceNode, 6, 32);
    }

    public CommandFigure(INode node, int margin, int maxLength) {
        XYLayout layout = new XYLayout();
        this.setFont(FontFactory.getInstance().getDefaultFont());
        this.setLayoutManager((LayoutManager)layout);
        this.margin = margin;
        this.maxLength = maxLength;
        int width = 0;
        int height = 0;
        CommandNode commandNode = (CommandNode)node;
        ResourceAndVerb resourceAndVerb = ((CommandExecution)commandNode.getObject()).getResourceAndVerb();
        Resource resource = resourceAndVerb.getResource();
        Image image = ResourceRenderer.asImage(resource);
        StringBuilder sb = new StringBuilder(ResourceRenderer.asVerb(resourceAndVerb.getVerb(), resourceAndVerb.getType()));
        String truncatedName = sb.toString();
        if (sb.length() > maxLength) {
            truncatedName = String.valueOf(sb.substring(0, maxLength)) + "...";
            TooltipFigure tooltipFigure = new TooltipFigure();
            tooltipFigure.setMessage(sb.toString());
            this.setToolTip((IFigure)tooltipFigure);
        }
        String text = truncatedName;
        this.titleFigure = new TitledImageFigure(image, text, 16384);
        this.add((IFigure)this.titleFigure, new Rectangle(new Point(6, 6), this.titleFigure.getPreferredSize()));
        width = width < this.titleFigure.getPreferredSize().width ? this.titleFigure.getPreferredSize().width : width;
        height = this.titleFigure.getPreferredSize().height;
        int leftColumnWidth = 0;
        Label resourceTitleLabel = new Label(Messages.getString("CommandFigure.Resource"));
        resourceTitleLabel.setFont(FontFactory.getInstance().getBoldFont());
        leftColumnWidth = leftColumnWidth < resourceTitleLabel.getPreferredSize().width ? resourceTitleLabel.getPreferredSize().width : leftColumnWidth;
        Label resourceLabel = new Label(resource.getName());
        resourceLabel.setFont(FontFactory.getInstance().getDefaultFont());
        this.add((IFigure)resourceTitleLabel, new Rectangle(new Point(6, 6 + height + 10), resourceTitleLabel.getPreferredSize()));
        this.add((IFigure)resourceLabel, new Rectangle(new Point(6 + leftColumnWidth + 6, 6 + height + 10), resourceLabel.getPreferredSize()));
        width = width < leftColumnWidth + 6 + resourceLabel.getPreferredSize().width ? leftColumnWidth + 6 + resourceLabel.getPreferredSize().width : width;
        height += 10 + resourceTitleLabel.getPreferredSize().height;
        Label timeTitleLabel = new Label(Messages.getString("CommandFigure.Time"));
        timeTitleLabel.setFont(FontFactory.getInstance().getBoldFont());
        leftColumnWidth = leftColumnWidth < timeTitleLabel.getPreferredSize().width ? timeTitleLabel.getPreferredSize().width : leftColumnWidth;
        Label timeLabel = new Label(DATE_FORMAT.format(((CommandExecution)commandNode.getObject()).getCommandTime()));
        timeLabel.setFont(FontFactory.getInstance().getDefaultFont());
        this.add((IFigure)timeTitleLabel, new Rectangle(new Point(6, 6 + height + 10), timeTitleLabel.getPreferredSize()));
        this.add((IFigure)timeLabel, new Rectangle(new Point(6 + leftColumnWidth + 6, 6 + height + 10), timeLabel.getPreferredSize()));
        width = width < leftColumnWidth + 6 + timeLabel.getPreferredSize().width ? leftColumnWidth + 6 + timeLabel.getPreferredSize().width : width;
        this.borderColorSelected = TypeColorFactory.getColor(resource, true);
        this.borderColorDeselected = TypeColorFactory.getColor(resource, false);
        Dimension size = new Dimension(width + 12, (height += 10 + timeTitleLabel.getPreferredSize().height) + 12);
        this.setPreferredSize(size);
    }

    public Figure getTitleFigure() {
        return this.titleFigure;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void paint(Graphics graphics) {
        graphics.setAntialias(1);
        Rectangle r = this.getBounds();
        Rectangle patternRec = r.getCopy();
        this.translateToAbsolute((Translatable)patternRec);
        if (this.selected) {
            graphics.setBackgroundPattern(new Pattern((Device)Display.getCurrent(), (float)(patternRec.x + patternRec.width / 2), (float)r.y, (float)(patternRec.x + patternRec.width / 2), (float)(r.y + patternRec.height), this.backgroundColor1Selected, this.backgroundColor2Selected));
        } else {
            graphics.setBackgroundPattern(new Pattern((Device)Display.getCurrent(), (float)(patternRec.x + patternRec.width / 2), (float)r.y, (float)(patternRec.x + patternRec.width / 2), (float)(r.y + patternRec.height), this.backgroundColor1Deselected, this.backgroundColor2Deselected));
        }
        graphics.fillRoundRectangle(new Rectangle(r.x + 1, r.y + 1, r.width - 4, r.height - 4), 5, 5);
        graphics.setBackgroundColor(new Color((Device)Display.getDefault(), 208, 223, 238));
        graphics.fillRectangle(new Rectangle(r.x + 2, r.y + 2, r.width - 5, 24));
        if (this.selected) {
            graphics.setBackgroundColor(new Color((Device)Display.getDefault(), 231, 231, 231));
        } else {
            graphics.setBackgroundColor(new Color((Device)Display.getDefault(), 241, 241, 241));
        }
        graphics.setForegroundColor(new Color((Device)Display.getDefault(), 236, 244, 252));
        graphics.drawLine(r.x + 1, r.y + 2, r.x + r.width - 4, r.y + 2);
        graphics.setForegroundColor(new Color((Device)Display.getDefault(), 229, 239, 249));
        graphics.drawLine(r.x + 1, r.y + 3, r.x + r.width - 4, r.y + 3);
        graphics.setForegroundColor(new Color((Device)Display.getDefault(), 222, 234, 245));
        graphics.drawLine(r.x + 1, r.y + 4, r.x + r.width - 4, r.y + 4);
        graphics.setForegroundColor(new Color((Device)Display.getDefault(), 215, 229, 242));
        graphics.drawLine(r.x + 1, r.y + 5, r.x + r.width - 4, r.y + 5);
        graphics.setForegroundColor(new Color((Device)Display.getDefault(), 162, 168, 184));
        graphics.drawLine(r.x + 2, r.y + 27, r.x + r.width - 4, r.y + 27);
        if (this.selected) {
            graphics.setLineWidth(2);
            graphics.setForegroundColor(this.borderColorSelected);
        } else {
            graphics.setLineWidth(1);
            graphics.setForegroundColor(this.borderColorDeselected);
        }
        graphics.setAlpha(64);
        graphics.drawRoundRectangle(new Rectangle(r.x + 1, r.y + 1, r.width - 2, r.height - 2), 7, 7);
        graphics.setAlpha(128);
        graphics.drawRoundRectangle(new Rectangle(r.x + 1, r.y + 1, r.width - 3, r.height - 3), 6, 6);
        graphics.setAlpha(255);
        graphics.drawRoundRectangle(new Rectangle(r.x + 1, r.y + 1, r.width - 4, r.height - 4), 5, 5);
        graphics.setForegroundColor(this.textColor);
        super.paint(graphics);
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
        this.repaint();
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }
}

