/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.editparts;

import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.model.viz.INestedNode;
import com.ibm.cics.ia.model.viz.INode;
import com.ibm.cics.ia.model.viz.ResourceFilter;
import com.ibm.cics.ia.model.viz.RootNode;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.ResourceConnectionsView;
import com.ibm.cics.ia.ui.viz.ResourceConnEditorInput;
import com.ibm.cics.ia.ui.viz.editparts.ResourceNodeGraphEditPart;
import org.eclipse.gef.Request;

public class TransactionNodeGraphEditPart
extends ResourceNodeGraphEditPart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public TransactionNodeGraphEditPart(INode resourceNode, ResourceFilter rootFilter) {
        super(resourceNode, rootFilter);
    }

    @Override
    public void performRequest(Request request) {
        this.showOutgoingConnections((INode)this.getModel());
    }

    private void showOutgoingConnections(INode node) {
        Region region = null;
        Platform platform = null;
        TSApplication application = null;
        Transaction transaction = (Transaction)node.getObject();
        INestedNode parent = node.getParent();
        while (parent != null) {
            Object object = parent.getObject();
            if (object != null) {
                if (object instanceof Region) {
                    region = (Region)object;
                } else if (object instanceof Platform) {
                    platform = (Platform)object;
                } else if (object instanceof TSApplication) {
                    application = (TSApplication)object;
                }
            }
            parent = parent.getParent();
        }
        Object rootObject = this.getRoot().getModel();
        if (rootObject != null && rootObject instanceof RootNode) {
            RootNode rootNode = (RootNode)rootObject;
            if (region == null && rootNode.getData((Object)"CONTEXT_REGION") != null && rootNode.getData((Object)"CONTEXT_REGION") instanceof Region) {
                region = (Region)rootNode.getData((Object)"CONTEXT_REGION");
            }
            if (platform == null && rootNode.getData((Object)"CONTEXT_PLATFORM") != null && rootNode.getData((Object)"CONTEXT_PLATFORM") instanceof Platform) {
                platform = (Platform)rootNode.getData((Object)"CONTEXT_PLATFORM");
            }
            if (application == null && rootNode.getData((Object)"CONTEXT_APPLICATION") != null && rootNode.getData((Object)"CONTEXT_APPLICATION") instanceof TSApplication) {
                application = (TSApplication)rootNode.getData((Object)"CONTEXT_APPLICATION");
            }
        }
        ResourceConnEditorInput input = new ResourceConnEditorInput((Resource)transaction, region, platform, application, transaction);
        ResourceConnectionsView newView = Activator.getResourceConnectionsView(input);
        newView.runSearch();
    }
}

