/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.editparts;

import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.viz.INestedNode;
import com.ibm.cics.ia.model.viz.INode;
import com.ibm.cics.ia.ui.ResourceRenderer;
import com.ibm.cics.ia.ui.ResourceTypeRenderer;
import com.ibm.cics.ia.ui.ShowDetailsStrategy;
import com.ibm.cics.ia.ui.viz.figures.ISelectableFigure;
import com.ibm.cics.ia.ui.viz.figures.NestedTimelineFigure;
import com.ibm.cics.ia.ui.viz.layoutmanagers.SortedGraphNode;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;

public class SortedGraphEditPart
extends AbstractGraphicalEditPart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2014, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final Rectangle zeroRectangle = new Rectangle(0, 0, 0, 0);
    protected AccessibleEditPart accessibleEditPart;
    protected String accessibleName;

    public SortedGraphEditPart(INode model) {
        this.setModel(model);
        Object object = model.getObject();
        if (object instanceof Program) {
            Program resource = (Program)object;
            StringBuilder sb = new StringBuilder(ResourceTypeRenderer.asText(resource.getTypeName()));
            sb.append(" ");
            sb.append(ResourceRenderer.asText((Resource)resource));
            this.accessibleName = sb.toString();
        }
    }

    protected List getModelChildren() {
        INestedNode node = (INestedNode)this.getModel();
        Object[] array = node.getChildren().values().toArray();
        return Arrays.asList(array);
    }

    protected IFigure createFigure() {
        INestedNode resourceNode = (INestedNode)this.getModel();
        return new NestedTimelineFigure(resourceNode);
    }

    protected void createEditPolicies() {
        NonResizableEditPolicy policy = new NonResizableEditPolicy(){

            protected void showSelection() {
                ((ISelectableFigure)SortedGraphEditPart.this.getFigure()).setSelected(true);
            }

            protected void hideSelection() {
                ((ISelectableFigure)SortedGraphEditPart.this.getFigure()).setSelected(false);
            }
        };
        policy.setDragAllowed(false);
        this.installEditPolicy("Selection Feedback", (EditPolicy)policy);
        policy.activate();
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accessibleEditPart == null) {
            this.accessibleEditPart = this.createAccessible();
        }
        return this.accessibleEditPart;
    }

    protected AccessibleEditPart createAccessible() {
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

            public void getName(AccessibleEvent e) {
                e.result = SortedGraphEditPart.this.accessibleName;
                System.out.println(e.result);
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 41;
            }

            public int hashCode() {
                return super.hashCode();
            }
        };
    }

    public void setFigureSelected(boolean selected) {
        ((ISelectableFigure)this.getFigure()).setSelected(selected);
    }

    public void applyGraphResuts(Map<SortedGraphEditPart, SortedGraphNode> editPartsToNodes) {
        this.applyOwnGraphResults(editPartsToNodes);
        this.applyChildGraphResults(editPartsToNodes);
    }

    protected void applyOwnGraphResults(Map<SortedGraphEditPart, SortedGraphNode> editPartsToNodes) {
        SortedGraphNode n = editPartsToNodes.get((Object)this);
        if (n == null) {
            this.getFigure().setBounds(zeroRectangle);
            return;
        }
        this.getFigure().setBounds(new Rectangle(n.getLocation(), n.getSize()));
        if (this.getFigure() instanceof NestedTimelineFigure) {
            NestedTimelineFigure figure = (NestedTimelineFigure)this.getFigure();
            figure.getTitleFigure().setLocation(new Point(this.getFigure().getBounds().x + 5, this.getFigure().getBounds().y + 5));
            figure.getTitleFigure().setSize(figure.getTitleFigure().getPreferredSize().expand(5, 5));
        }
    }

    protected void applyChildGraphResults(Map<SortedGraphEditPart, SortedGraphNode> editPartsToNodes) {
        for (Object child : this.getChildren()) {
            if (!(child instanceof SortedGraphEditPart)) continue;
            ((SortedGraphEditPart)((Object)child)).applyGraphResuts(editPartsToNodes);
        }
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            Object source = ((INode)this.getModel()).getObject();
            ShowDetailsStrategy.showDetails(source);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeEditPolicy("Selection Feedback");
    }
}

