/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.editparts;

import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.viz.INode;
import com.ibm.cics.ia.ui.ResourceRenderer;
import com.ibm.cics.ia.ui.ResourceTypeRenderer;
import com.ibm.cics.ia.ui.ShowDetailsStrategy;
import com.ibm.cics.ia.ui.viz.editparts.IDataEditPart;
import com.ibm.cics.ia.ui.viz.figures.ResourceFigure;
import java.util.HashMap;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;

public class ResourceNodeEditPart
extends AbstractGraphicalEditPart
implements IDataEditPart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private HashMap data = new HashMap();
    private AccessibleEditPart accessibleEditPart;
    private String accessibleName;

    public ResourceNodeEditPart(INode node) {
        this.setModel(node);
        Resource resource = (Resource)node.getObject();
        StringBuilder sb = new StringBuilder(ResourceTypeRenderer.asText(resource.getTypeName()));
        sb.append(" ");
        sb.append(ResourceRenderer.asText(resource));
        this.accessibleName = sb.toString();
    }

    protected IFigure createFigure() {
        INode node = (INode)this.getModel();
        ResourceFigure figure = new ResourceFigure(node);
        this.setData("RESOURCE", node.getObject());
        return figure;
    }

    protected void createEditPolicies() {
        NonResizableEditPolicy selectionPolicy = new NonResizableEditPolicy(){

            protected void showSelection() {
                ((ResourceFigure)ResourceNodeEditPart.this.getFigure()).setSelected(true);
            }

            protected void hideSelection() {
                ((ResourceFigure)ResourceNodeEditPart.this.getFigure()).setSelected(false);
            }
        };
        selectionPolicy.setDragAllowed(false);
        this.installEditPolicy("Selection Feedback", (EditPolicy)selectionPolicy);
        selectionPolicy.activate();
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accessibleEditPart == null) {
            this.accessibleEditPart = this.createAccessible();
        }
        return this.accessibleEditPart;
    }

    protected AccessibleEditPart createAccessible() {
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

            public void getName(AccessibleEvent e) {
                e.result = ResourceNodeEditPart.this.accessibleName;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 41;
            }

            public int hashCode() {
                return super.hashCode();
            }
        };
    }

    @Override
    public void setData(Object key, Object value) {
        this.data.put(key, value);
    }

    @Override
    public void setData(Object value) {
        this.data.put(null, value);
    }

    @Override
    public Object getData(Object key) {
        return this.data.get(key);
    }

    @Override
    public Object getData() {
        return this.data.get(null);
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            Object source = this.getData("RESOURCE");
            ShowDetailsStrategy.showDetails(source);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeEditPolicy("Selection Feedback");
    }
}

