/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.editparts;

import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.viz.INestedNode;
import com.ibm.cics.ia.model.viz.INode;
import com.ibm.cics.ia.model.viz.ResourceFilter;
import com.ibm.cics.ia.ui.ResourceRenderer;
import com.ibm.cics.ia.ui.ResourceTypeRenderer;
import com.ibm.cics.ia.ui.viz.anchors.GraphInOutAnchor;
import com.ibm.cics.ia.ui.viz.editparts.ConnectionsGraphEditPart;
import com.ibm.cics.ia.ui.viz.figures.ISelectableFigure;
import com.ibm.cics.ia.ui.viz.figures.NestedResourceFigure;
import com.ibm.cics.ia.ui.viz.figures.ResourceFigure;
import com.ibm.cics.ia.ui.viz.figures.TitledImageFigure;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;

public class NestedResourceGraphNodeEditPart
extends ConnectionsGraphEditPart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private GraphInOutAnchor sourceAnchor;
    private GraphInOutAnchor targetAnchor;
    private ResourceFilter resourceFilter;
    private AccessibleEditPart accessibleEditPart;
    private static int DEFAULT_MARGIN = 6;
    private String accessibleName;

    public NestedResourceGraphNodeEditPart(INestedNode resourceNode, ResourceFilter rootFilter) {
        this.setModel(resourceNode);
        Resource resource = (Resource)resourceNode.getObject();
        StringBuilder sb = new StringBuilder(ResourceTypeRenderer.asText(resource.getTypeName()));
        sb.append(" ");
        sb.append(ResourceRenderer.asText(resource));
        this.accessibleName = sb.toString();
    }

    protected List getModelChildren() {
        INestedNode node = (INestedNode)this.getModel();
        Object[] array = node.getChildren().values().toArray();
        return Arrays.asList(array);
    }

    protected List getModelSourceConnections() {
        INode model = (INode)this.getModel();
        return model.getOutgoingConnections();
    }

    protected List getModelTargetConnections() {
        INode model = (INode)this.getModel();
        return model.getIncomingConnections();
    }

    protected IFigure createFigure() {
        INestedNode resourceNode = (INestedNode)this.getModel();
        return new NestedResourceFigure(resourceNode);
    }

    protected void createEditPolicies() {
        NonResizableEditPolicy policy = new NonResizableEditPolicy(){

            protected void showSelection() {
                ((ISelectableFigure)NestedResourceGraphNodeEditPart.this.getFigure()).setSelected(true);
                NestedResourceGraphNodeEditPart.this.setIncomingConnectionsSelected((INode)NestedResourceGraphNodeEditPart.this.getModel(), true);
                NestedResourceGraphNodeEditPart.this.setOutgoingConnectionsSelected((INode)NestedResourceGraphNodeEditPart.this.getModel(), true);
            }

            protected void hideSelection() {
                ((ISelectableFigure)NestedResourceGraphNodeEditPart.this.getFigure()).setSelected(false);
                NestedResourceGraphNodeEditPart.this.setIncomingConnectionsSelected((INode)NestedResourceGraphNodeEditPart.this.getModel(), false);
                NestedResourceGraphNodeEditPart.this.setOutgoingConnectionsSelected((INode)NestedResourceGraphNodeEditPart.this.getModel(), false);
            }
        };
        policy.setDragAllowed(false);
        this.installEditPolicy("Selection Feedback", (EditPolicy)policy);
        policy.activate();
    }

    public void installEditPolicy(Object key, EditPolicy editPolicy) {
        super.installEditPolicy(key, editPolicy);
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accessibleEditPart == null) {
            this.accessibleEditPart = this.createAccessible();
        }
        return this.accessibleEditPart;
    }

    protected AccessibleEditPart createAccessible() {
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

            public void getName(AccessibleEvent e) {
                e.result = NestedResourceGraphNodeEditPart.this.accessibleName;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 41;
            }

            public int hashCode() {
                return super.hashCode();
            }
        };
    }

    public void setIncomingConnectionsSelected(INode node, boolean selected) {
        List incomingConnections = node.getIncomingConnections();
        if (incomingConnections == null || incomingConnections.isEmpty()) {
            return;
        }
    }

    public void setOutgoingConnectionsSelected(INode node, boolean selected) {
        List outgoingConnections = node.getOutgoingConnections();
        if (outgoingConnections == null || outgoingConnections.isEmpty()) {
            return;
        }
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart arg0) {
        if (this.sourceAnchor == null) {
            this.sourceAnchor = new GraphInOutAnchor(this.getFigure(), -1, false);
        }
        return this.sourceAnchor;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request arg0) {
        if (this.sourceAnchor == null) {
            this.sourceAnchor = new GraphInOutAnchor(this.getFigure(), -1, false);
        }
        return this.sourceAnchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart arg0) {
        if (this.targetAnchor == null) {
            this.targetAnchor = new GraphInOutAnchor(this.getFigure(), -1, true);
        }
        return this.targetAnchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request arg0) {
        if (this.targetAnchor == null) {
            this.targetAnchor = new GraphInOutAnchor(this.getFigure(), -1, true);
        }
        return this.targetAnchor;
    }

    public void setSelected(boolean selected) {
        ((ResourceFigure)this.getFigure()).setSelected(selected);
    }

    @Override
    protected void applyOwnGraphResults(CompoundDirectedGraph graph, Map<Object, Object> map) {
        if (this.hasVisibleChildren()) {
            NestedResourceFigure figure = (NestedResourceFigure)this.getFigure();
            TitledImageFigure titleFigure = (TitledImageFigure)figure.getTitleFigure();
            titleFigure.setLocation(new Point(figure.getBounds().x + DEFAULT_MARGIN, figure.getBounds().y + DEFAULT_MARGIN));
            Dimension size = titleFigure.getPreferredSize().getCopy();
            titleFigure.setSize(size.expand(DEFAULT_MARGIN, DEFAULT_MARGIN));
            figure.setPreferredSize(size.expand(DEFAULT_MARGIN, DEFAULT_MARGIN));
        }
        super.applyOwnGraphResults(graph, map);
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeEditPolicy("Selection Feedback");
    }

    @Override
    public void filterOut(String text) {
        super.filterOut(text);
        if (this.accessibleName != null && !this.accessibleName.matches(text)) {
            ((NestedResourceFigure)this.getFigure()).setOpacity(96);
        } else {
            ((NestedResourceFigure)this.getFigure()).setOpacity(255);
        }
    }
}

