/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.editparts;

import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.viz.IModelChangeListener;
import com.ibm.cics.ia.model.viz.INestedNode;
import com.ibm.cics.ia.model.viz.INode;
import com.ibm.cics.ia.ui.ResourceRenderer;
import com.ibm.cics.ia.ui.ResourceTypeRenderer;
import com.ibm.cics.ia.ui.viz.editparts.IDataEditPart;
import com.ibm.cics.ia.ui.viz.editparts.Messages;
import com.ibm.cics.ia.ui.viz.figures.NestedResourceExpandableFigure;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;

public class NestedResourceEditPart
extends AbstractGraphicalEditPart
implements IModelChangeListener<INestedNode>,
IDataEditPart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private HashMap data = new HashMap();
    private AccessibleEditPart accessibleEditPart;
    private String accessibleName;

    protected List getModelChildren() {
        INestedNode node = (INestedNode)this.getModel();
        Object[] array = node.getChildren().values().toArray();
        return Arrays.asList(array);
    }

    public NestedResourceEditPart(INestedNode node) {
        this.setModel(node);
        node.addModelChangeListener((IModelChangeListener)this);
        Resource resource = (Resource)node.getObject();
        StringBuilder sb = new StringBuilder(ResourceTypeRenderer.asText(resource.getTypeName()));
        sb.append(" ");
        sb.append(ResourceRenderer.asText(resource));
        this.accessibleName = sb.toString();
    }

    protected IFigure createFigure() {
        INestedNode node = (INestedNode)this.getModel();
        Resource resource = (Resource)node.getObject();
        NestedResourceExpandableFigure figure = new NestedResourceExpandableFigure(node);
        figure.updateSummaries();
        this.setData("RESOURCE", node.getObject());
        return figure;
    }

    public IFigure getContentPane() {
        return ((NestedResourceExpandableFigure)this.getFigure()).getContentFigure();
    }

    protected void createEditPolicies() {
        NonResizableEditPolicy selectionPolicy = new NonResizableEditPolicy(){

            protected void showSelection() {
                ((NestedResourceExpandableFigure)NestedResourceEditPart.this.getFigure()).setSelected(true);
            }

            protected void hideSelection() {
                ((NestedResourceExpandableFigure)NestedResourceEditPart.this.getFigure()).setSelected(false);
            }
        };
        selectionPolicy.setDragAllowed(false);
        this.installEditPolicy("Selection Feedback", (EditPolicy)selectionPolicy);
        selectionPolicy.activate();
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accessibleEditPart == null) {
            this.accessibleEditPart = this.createAccessible();
        }
        return this.accessibleEditPart;
    }

    protected AccessibleEditPart createAccessible() {
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

            public void getName(AccessibleEvent e) {
                e.result = NestedResourceEditPart.this.isExpanded() ? MessageFormat.format(Messages.getString("NestedResourceEditPart.Accessible.Expanded"), NestedResourceEditPart.this.accessibleName) : MessageFormat.format(Messages.getString("NestedResourceEditPart.Accessible.Collapsed"), NestedResourceEditPart.this.accessibleName);
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 41;
            }

            public int hashCode() {
                return super.hashCode();
            }
        };
    }

    @Override
    public void setData(Object key, Object value) {
        this.data.put(key, value);
    }

    @Override
    public void setData(Object value) {
        this.data.put(null, value);
    }

    @Override
    public Object getData(Object key) {
        return this.data.get(key);
    }

    @Override
    public Object getData() {
        return this.data.get(null);
    }

    public void setExpanded(boolean expanded, boolean recursive) {
        NestedResourceExpandableFigure figure = (NestedResourceExpandableFigure)this.getFigure();
        if (figure != null) {
            figure.setExpanded(expanded);
        }
        if (recursive) {
            List children = this.getChildren();
            for (AbstractGraphicalEditPart child : children) {
                if (!(child instanceof NestedResourceEditPart)) continue;
                ((NestedResourceEditPart)child).setExpanded(expanded, true);
            }
        }
    }

    public boolean isExpanded() {
        NestedResourceExpandableFigure figure = (NestedResourceExpandableFigure)this.getFigure();
        if (figure != null) {
            return figure.isExpnaded();
        }
        return false;
    }

    public void onModelChanged(INestedNode model) {
        NestedResourceExpandableFigure figure = (NestedResourceExpandableFigure)this.getFigure();
        figure.updateSummaries();
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeEditPolicy("Selection Feedback");
        ((INode)this.getModel()).removeModelChangeListener((IModelChangeListener)this);
    }
}

