/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz;

import com.ibm.cics.ia.model.viz.INestedNode;
import com.ibm.cics.ia.ui.viz.editparts.ConnectionsDiagramRootEditPart;
import com.ibm.cics.ia.ui.viz.editparts.ConnectionsEdgeEditPart;
import com.ibm.cics.ia.ui.viz.editparts.ConnectionsGraphEditPart;
import com.ibm.cics.ia.ui.viz.editparts.NestedResourceEditPart;
import com.ibm.cics.ia.ui.viz.editparts.NestedResourceGraphNodeEditPart;
import com.ibm.cics.ia.ui.viz.editparts.ResourceNodeGraphEditPart;
import com.ibm.cics.ia.ui.viz.figures.TitledExpandableFigure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.swt.events.KeyEvent;

public class ResourceVizualizationKeyHandler
extends GraphicalViewerKeyHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2014, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public GraphicalViewer viewer;

    public ResourceVizualizationKeyHandler(GraphicalViewer viewer) {
        super(viewer);
        this.viewer = viewer;
    }

    public boolean keyPressed(KeyEvent event) {
        GraphicalEditPart editPart;
        int key;
        block26: {
            block27: {
                key = event.keyCode;
                editPart = this.getFocusEditPart();
                if (editPart instanceof NestedResourceEditPart) {
                    if (event.keyCode == 32) {
                        NestedResourceEditPart resourceEditPart = (NestedResourceEditPart)editPart;
                        TitledExpandableFigure figure = (TitledExpandableFigure)resourceEditPart.getFigure();
                        if (figure.isButtonFocused()) {
                            return false;
                        }
                        resourceEditPart.setExpanded(!resourceEditPart.isExpanded(), false);
                        return true;
                    }
                    return super.keyPressed(event);
                }
                if (!(editPart instanceof ResourceNodeGraphEditPart) && !(editPart instanceof NestedResourceGraphNodeEditPart)) break block26;
                ConnectionsGraphEditPart resourceGraphEditPart = (ConnectionsGraphEditPart)editPart;
                if (editPart.getTargetConnections().size() != 0 || key != 0x1000002 && key != 0x1000001 || (event.stateMask & 0x10000) != 0) break block27;
                ArrayList<ConnectionsGraphEditPart> siblings = new ArrayList<ConnectionsGraphEditPart>();
                INestedNode parentNode = null;
                if (editPart.getParent() instanceof NestedResourceGraphNodeEditPart) {
                    NestedResourceGraphNodeEditPart nestedGraphNodePart = (NestedResourceGraphNodeEditPart)editPart.getParent();
                    parentNode = (INestedNode)nestedGraphNodePart.getModel();
                } else if (editPart.getParent() instanceof ConnectionsDiagramRootEditPart) {
                    ConnectionsDiagramRootEditPart rootPart = (ConnectionsDiagramRootEditPart)editPart.getParent();
                    parentNode = (INestedNode)rootPart.getModel();
                }
                if (parentNode != null) {
                    Collection children = parentNode.getChildren().values();
                    for (Object object : children) {
                        ConnectionsGraphEditPart sibling;
                        EditPart part = (EditPart)this.viewer.getEditPartRegistry().get(object);
                        if (!(part instanceof ConnectionsGraphEditPart) || (sibling = (ConnectionsGraphEditPart)part).getTargetConnections().size() != 0) continue;
                        siblings.add(sibling);
                    }
                }
                ConnectionsGraphEditPart[] siblingsArray = siblings.toArray(new ConnectionsGraphEditPart[0]);
                Arrays.sort(siblingsArray, new Comparator<ConnectionsGraphEditPart>(){

                    @Override
                    public int compare(ConnectionsGraphEditPart o1, ConnectionsGraphEditPart o2) {
                        IFigure f1 = o1.getFigure();
                        IFigure f2 = o2.getFigure();
                        if (f1.getBounds().getCenter().y < f2.getBounds().getCenter().y) {
                            return -1;
                        }
                        if (f1.getBounds().getCenter().y > f2.getBounds().getCenter().y) {
                            return 1;
                        }
                        if (f1.getBounds().getCenter().x < f2.getBounds().getCenter().x) {
                            return -1;
                        }
                        if (f1.getBounds().getCenter().x > f2.getBounds().getCenter().x) {
                            return 1;
                        }
                        return 0;
                    }
                });
                if (key == 0x1000001) {
                    ConnectionsGraphEditPart previous = null;
                    ConnectionsGraphEditPart[] connectionsGraphEditPartArray = siblingsArray;
                    int sibling = siblingsArray.length;
                    int part = 0;
                    while (part < sibling) {
                        ConnectionsGraphEditPart sibling2 = connectionsGraphEditPartArray[part];
                        if (((Object)((Object)sibling2)).equals((Object)resourceGraphEditPart) && previous != null) break;
                        if (sibling2.isVisible()) {
                            previous = sibling2;
                        }
                        ++part;
                    }
                    if (previous != null) {
                        this.navigateTo((EditPart)previous, event);
                    }
                    return true;
                }
                if (key != 0x1000002) break block27;
                ConnectionsGraphEditPart next = null;
                boolean hitCurrent = false;
                ConnectionsGraphEditPart[] connectionsGraphEditPartArray = siblingsArray;
                int n = siblingsArray.length;
                int sibling = 0;
                while (sibling < n) {
                    block30: {
                        ConnectionsGraphEditPart sibling3;
                        block28: {
                            block29: {
                                sibling3 = connectionsGraphEditPartArray[sibling];
                                if (hitCurrent) break block28;
                                if (!((Object)((Object)sibling3)).equals((Object)resourceGraphEditPart)) break block29;
                                hitCurrent = true;
                                break block30;
                            }
                            if (!sibling3.isVisible() || next != null) break block30;
                            next = sibling3;
                            break block30;
                        }
                        if (sibling3.isVisible()) {
                            next = sibling3;
                            break;
                        }
                    }
                    ++sibling;
                }
                if (next != null) {
                    this.navigateTo((EditPart)next, event);
                }
                return true;
            }
            return super.keyPressed(event);
        }
        if (editPart instanceof ConnectionsEdgeEditPart) {
            ConnectionsEdgeEditPart conn = (ConnectionsEdgeEditPart)editPart;
            if (key == 0x1000003) {
                this.navigateTo(conn.getSource(), event);
                return true;
            }
            if (key == 0x1000004) {
                this.navigateTo(conn.getTarget(), event);
                return true;
            }
            if (key == 0x1000001) {
                ResourceNodeGraphEditPart resourceEditPart = (ResourceNodeGraphEditPart)conn.getSource();
                List sourceConnections = resourceEditPart.getSourceConnections();
                ConnectionsEdgeEditPart previous = null;
                for (Object object : sourceConnections) {
                    ConnectionsEdgeEditPart conn2 = (ConnectionsEdgeEditPart)((Object)object);
                    if (((Object)((Object)conn2)).equals((Object)conn) && previous != null) break;
                    if (!conn2.isVisible()) continue;
                    previous = conn2;
                }
                if (previous != null) {
                    this.navigateTo((EditPart)previous, event);
                }
                return true;
            }
            if (key == 0x1000002) {
                ResourceNodeGraphEditPart resourceEditPart = (ResourceNodeGraphEditPart)conn.getSource();
                List sourceConnections = resourceEditPart.getSourceConnections();
                ConnectionsEdgeEditPart next = null;
                boolean hitCurrent = false;
                for (Object object : sourceConnections) {
                    ConnectionsEdgeEditPart conn2 = (ConnectionsEdgeEditPart)((Object)object);
                    if (!hitCurrent) {
                        if (((Object)((Object)conn2)).equals((Object)conn)) {
                            hitCurrent = true;
                            continue;
                        }
                        if (!conn2.isVisible() || next != null) continue;
                        next = conn2;
                        continue;
                    }
                    if (!conn2.isVisible()) continue;
                    next = conn2;
                    break;
                }
                if (next != null) {
                    this.navigateTo((EditPart)next, event);
                }
                return true;
            }
        }
        return super.keyPressed(event);
    }

    protected List getNavigationSiblings() {
        GraphicalEditPart focusPart = this.getFocusEditPart();
        if (focusPart instanceof ResourceNodeGraphEditPart) {
            ResourceNodeGraphEditPart graphEditPart = (ResourceNodeGraphEditPart)focusPart;
            ArrayList list = new ArrayList();
            list.addAll(graphEditPart.getSourceConnections());
            list.addAll(graphEditPart.getTargetConnections());
            return list;
        }
        if (focusPart.getParent() != null) {
            List aList = focusPart.getParent().getChildren();
            Object[] objectArray = aList.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object aChild = objectArray[n2];
                GraphicalEditPart editPart = (GraphicalEditPart)aChild;
                if (editPart instanceof ResourceNodeGraphEditPart && ((ResourceNodeGraphEditPart)editPart).isVisible()) {
                    aList.remove(aChild);
                } else if (editPart instanceof ConnectionsEdgeEditPart && ((ConnectionsEdgeEditPart)editPart).isVisible()) {
                    aList.remove(aChild);
                }
                ++n2;
            }
            return aList;
        }
        if (focusPart.getParent() != null) {
            return focusPart.getParent().getChildren();
        }
        ArrayList<GraphicalEditPart> list = new ArrayList<GraphicalEditPart>();
        list.add(focusPart);
        return list;
    }
}

