/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz;

import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.model.viz.INestedNode;
import com.ibm.cics.ia.model.viz.INode;
import com.ibm.cics.ia.model.viz.NestedNode;
import com.ibm.cics.ia.model.viz.Node;
import com.ibm.cics.ia.model.viz.NodeConnection;
import com.ibm.cics.ia.model.viz.ResourceFilter;
import com.ibm.cics.ia.model.viz.RootNode;
import com.ibm.cics.ia.ui.viz.ResourceConnectionsEditPartFactoryPresenter;
import com.ibm.cics.ia.ui.viz.editparts.ConnectionsDiagramRootEditPart;
import com.ibm.cics.ia.ui.viz.editparts.ConnectionsEdgeEditPart;
import com.ibm.cics.ia.ui.viz.editparts.NestedResourceGraphNodeEditPart;
import com.ibm.cics.ia.ui.viz.editparts.ResourceNodeGraphEditPart;
import com.ibm.cics.ia.ui.viz.editparts.TransactionNodeGraphEditPart;
import java.util.HashMap;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;

public class ResourceConnectionsEditPartFactory
implements EditPartFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    ResourceFilter resourceFilter;
    private ResourceConnectionsEditPartFactoryPresenter presenter;
    private HashMap<Object, EditPart> parts = new HashMap();

    public ResourceConnectionsEditPartFactory(ResourceFilter filter) {
        this.resourceFilter = filter;
    }

    public EditPart createEditPart(EditPart context, Object model) {
        Object result = this.parts.get(model);
        if (result == null) {
            if (model instanceof RootNode) {
                if (this.presenter != null) {
                    this.presenter.onFigureCreated();
                }
                result = new ConnectionsDiagramRootEditPart((RootNode)model);
                this.parts.put(model, (EditPart)result);
            } else if (model instanceof NodeConnection) {
                if (this.presenter != null) {
                    this.presenter.onFigureCreated();
                }
                result = new ConnectionsEdgeEditPart((NodeConnection)model);
                this.parts.put(model, (EditPart)result);
            } else if (model instanceof NestedNode) {
                if (this.presenter != null) {
                    this.presenter.onFigureCreated();
                }
                result = new NestedResourceGraphNodeEditPart((INestedNode)((NestedNode)model), this.resourceFilter);
                this.parts.put(model, (EditPart)result);
            } else if (model instanceof Node) {
                Object object;
                if (this.presenter != null) {
                    this.presenter.onFigureCreated();
                }
                result = (object = ((Node)model).getObject()) instanceof Transaction ? new TransactionNodeGraphEditPart((INode)((Node)model), this.resourceFilter) : new ResourceNodeGraphEditPart((INode)((Node)model), this.resourceFilter);
                this.parts.put(model, (EditPart)result);
            }
        }
        result.setModel(model);
        return result;
    }

    public void setPresenter(ResourceConnectionsEditPartFactoryPresenter presenter) {
        this.presenter = presenter;
    }

    public EditPart getEditPart(Object model) {
        return this.parts.get(model);
    }
}

