/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.handlers;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.StoredProcedureCommand;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.storedproc.ProcedureCIUSPPUR;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.PurgeQueueByPrefixDialog;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public class PurgeQueueByPrefixesHandler
extends AbstractHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(PurgeQueueByPrefixesHandler.class.getPackage().getName());
    private String title;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.procedureExecute(this.getParameters());
        return null;
    }

    private HashMap<String, String> getParameters() {
        PurgeQueueByPrefixDialog dialog = new PurgeQueueByPrefixDialog(Display.getCurrent().getActiveShell());
        int returnCode = dialog.open();
        if (returnCode == 0) {
            return dialog.getParameters();
        }
        return new HashMap<String, String>();
    }

    private boolean procedureExecute(HashMap<String, String> parameters) {
        Debug.enter((Logger)logger, (String)PurgeQueueByPrefixesHandler.class.getName(), (String)"procedureExecute", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "parameters size: " + parameters.size()});
        if (parameters.get("IN_PREOBJ") == null) {
            return false;
        }
        Integer length = parameters.get("IN_PREOBJ").trim().length();
        final String lengthString = length.toString();
        final String pType = (parameters.containsKey("IN_PTYPE") ? parameters.get("IN_PTYPE") : "ENQ/DEQ").toUpperCase();
        final String prefix = parameters.get("IN_PREOBJ");
        final StoredProcedureCommand command = new StoredProcedureCommand(){

            public Object processRow(ResultSet resultSet) throws SQLException {
                return resultSet.getString(1);
            }

            public SelectionObject getSelectionObject() {
                return new ProcedureCIUSPPUR().getSelectionObject(pType, prefix, lengthString);
            }
        };
        command.setCategory("com.ibm.cics.ia.connection.db2");
        command.setAsync(false);
        try {
            new ProgressMonitorDialog(null).run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    command.start();
                    if (command.status() != 1 && command.status() != 3 && command.status() == 2) {
                        MessageDialog.open((int)1, null, (String)"Error", (String)Messages.getString("PurgeQueueByPrefix.procedureExecuteError.message"), (int)1);
                        Debug.exit((Logger)logger, (String)PurgeQueueByPrefixesHandler.class.getName(), (String)"procedureExecute", (Object)"SQL error");
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            MessageDialog.open((int)1, null, (String)"Error", (String)Messages.getString("PurgeQueueByPrefix.procedureExecuteError.message"), (int)1);
            Debug.warning((Logger)logger, (String)PurgeQueueByPrefixesHandler.class.getName(), (String)"procedureExecute", (String)"InvocationTargetException", (Throwable)e);
        }
        catch (InterruptedException e) {
            Debug.error((Logger)logger, (String)PurgeQueueByPrefixesHandler.class.getName(), (String)"procedureExecute", (Throwable)e);
        }
        Debug.exit((Logger)logger, (String)PurgeQueueByPrefixesHandler.class.getName(), (String)"procedureExecute", (Object)"return true");
        return true;
    }
}

