/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.handlers;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.zos.ui.views.DataSetsExplorer;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenZOSDataSetsExplorerHandler
implements IHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(OpenZOSDataSetsExplorerHandler.class.getPackage().getName());
    private static final String DSNAME = "dsname";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Debug.enter((Logger)logger, (String)OpenZOSDataSetsExplorerHandler.class.getName(), (String)"execute", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String dsname = event.getParameter(DSNAME);
        if (dsname == null) {
            return null;
        }
        try {
            DataSetsExplorer dataSetsExplorer = (DataSetsExplorer)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.ibm.cics.zos.ui.views.mvsfiles");
            dataSetsExplorer.setTextAndRefresh(dsname);
        }
        catch (PartInitException ex) {
            IAPlugin.getDefault().logError("Unable to find ZOS Data Sets explorer", (Throwable)ex);
            Debug.exit((Logger)logger, (String)OpenZOSDataSetsExplorerHandler.class.getName(), (String)"execute");
            return null;
        }
        Debug.exit((Logger)logger, (String)OpenZOSDataSetsExplorerHandler.class.getName(), (String)"execute");
        return dsname;
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

