/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.handlers;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.ia.model.AtomContent;
import com.ibm.cics.ia.model.CincCollector;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.CommandFlowEditor;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.ui.IEditorPart;

public class OpenCommandFlowEditorHandler
implements IHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(OpenCommandFlowEditorHandler.class.getPackage().getName());
    private static final String CONFIGURATION_ID = "configurationid";

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Debug.enter((Logger)logger, (String)OpenCommandFlowEditorHandler.class.getName(), (String)"execute", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String configurationId = event.getParameter(CONFIGURATION_ID);
        if (!IAUtilities.hasContent((String)configurationId)) {
            Debug.exit((Logger)logger, (String)OpenCommandFlowEditorHandler.class.getName(), (String)"execute");
            return null;
        }
        ConnectionProfile conf = ConnectionsPlugin.getDefault().getConnectionService().getConnectionManager().getConnectionProfile(configurationId);
        CredentialsConfiguration credentials = conf.getCredentials();
        String userID = credentials.getUserID();
        CincCollector cincCollector = ResourceFactory.getSingleton().getCincCollector(configurationId, userID);
        IEditorPart editor = Activator.openEditor(CommandFlowEditor.DEFAULT_EDITOR_INPUT, "com.ibm.cics.ia.ui.CommandFlowEditor", false);
        if (editor != null) {
            ((CommandFlowEditor)editor).setInput((AtomContent)cincCollector);
        }
        Debug.exit((Logger)logger, (String)OpenCommandFlowEditorHandler.class.getName(), (String)"execute");
        return configurationId;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

