/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.handlers;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.EngineShell;
import com.ibm.cics.dbfunc.command.StoredProcedureCommand;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.dbfunc.model.StoredProcedure;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.storedproc.ProcedureCIUSPDEL;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.TypeValueDialog;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteByCollectionIdHandler
extends AbstractHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(DeleteByCollectionIdHandler.class.getPackage().getName());
    private static EngineShell.EngineStatus engineStatus;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Debug.enter((Logger)logger, (String)DeleteByCollectionIdHandler.class.getName(), (String)"execute", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            final String collectionId = (String)((IStructuredSelection)selection).getFirstElement();
            MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 200);
            final String taskName = MessageFormat.format(Messages.getString("DeleteData"), collectionId);
            messageBox.setText(taskName);
            messageBox.setMessage(taskName);
            int result = messageBox.open();
            if (result == 64) {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
                try {
                    dialog.run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            Debug.enter((Logger)logger, (String)"DeleteByCollectionIdHandler.execute().ProgressMonitorDialog", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                            monitor.beginTask(taskName, -1);
                            StoredProcedureCommand command = new StoredProcedureCommand(){
                                private SelectionObject selectionObject;

                                public Object processRow(ResultSet resultSet) throws SQLException {
                                    return null;
                                }

                                public SelectionObject getSelectionObject() {
                                    return this.selectionObject == null ? (this.selectionObject = new ProcedureCIUSPDEL().getSelectionObject("D", collectionId)) : this.selectionObject;
                                }
                            };
                            command.setCategory("com.ibm.cics.ia.connection.db2");
                            command.setAsync(false);
                            command.start();
                            DeleteByCollectionIdHandler.this.updateUI(collectionId, ((StoredProcedure)command.getSelectionObject()).getOutputValues());
                            monitor.done();
                            Debug.exit((Logger)logger, (String)"DeleteByCollectionIdHandler.execute().ProgressMonitorDialog", (String)"run");
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    Debug.warning((Logger)logger, (String)DeleteByCollectionIdHandler.class.getName(), (String)"execute", (Throwable)e, new HashMap());
                    IAPlugin.getDefault().logError("Unable to delete data", (Throwable)e);
                }
                catch (InterruptedException e) {
                    Debug.warning((Logger)logger, (String)DeleteByCollectionIdHandler.class.getName(), (String)"execute", (Throwable)e, new HashMap());
                    IAPlugin.getDefault().logError("Unable to delete data", (Throwable)e);
                }
            }
        }
        Debug.exit((Logger)logger, (String)DeleteByCollectionIdHandler.class.getName(), (String)"execute");
        return null;
    }

    private void updateUI(final String collectionId, final Map<String, Object> nameToValue) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Debug.enter((Logger)logger, (String)"DeleteByCollectionIdHandler.updateUI.syncExec.Runnable()", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                String title = MessageFormat.format(Messages.getString("DeleteData.completed.title"), collectionId);
                String messagePrefix = "DeleteData.completed.msg";
                String message = Messages.getString(messagePrefix);
                TypeValueDialog dlg = new TypeValueDialog(Display.getCurrent().getActiveShell(), nameToValue, title, message, String.valueOf(messagePrefix) + ".");
                dlg.open();
                Activator.getCollectionIdsView().runSearch();
                if (collectionId.equals(IASQLCommand.getCollectionId())) {
                    Activator.getDefault().getCollectionIdWidget().resetCollectionId();
                } else {
                    Activator.getDefault().getCollectionIdWidget().setCollectionId(IASQLCommand.getCollectionId());
                }
                Debug.exit((Logger)logger, (String)"DeleteByCollectionIdHandler.updateUI.syncExec.Runnable()", (String)"run");
            }
        });
    }
}

