/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.handlers;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.ia.model.CincCollector;
import com.ibm.cics.ia.model.CintCollector;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.actions.CollectorAction;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;

public class CollectorActionHandler
implements IHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CollectorActionHandler.class.getPackage().getName());
    private static final String CONFIGURATION_ID = "configurationid";
    private static final String ACTION = "action";
    private static final String REGION = "region";

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Debug.enter((Logger)logger, (String)CollectorActionHandler.class.getName(), (String)"execute", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String configurationId = event.getParameter(CONFIGURATION_ID);
        String action = event.getParameter(ACTION);
        if (!IAUtilities.hasContent((String)configurationId)) {
            return null;
        }
        ConnectionProfile profile = ConnectionsPlugin.getDefault().getConnectionService().getConnectionManager().getConnectionProfile(configurationId);
        if (CollectorAction.CINC_START_ACTION.equals(action) || CollectorAction.CINC_STOP_ACTION.equals(action)) {
            CredentialsConfiguration credentials = profile.getCredentials();
            String userID = credentials.getUserID();
            CincCollector cincCollector = ResourceFactory.getSingleton().getCincCollector(configurationId, userID);
            CollectorAction collectorAction = new CollectorAction();
            collectorAction.setCincCollector(cincCollector);
            collectorAction.setId(action);
            collectorAction.run();
            return configurationId;
        }
        if (CollectorAction.CINT_START_ACTION.equals(action) || CollectorAction.CINT_STOP_ACTION.equals(action)) {
            String region = event.getParameter(REGION);
            if (!IAUtilities.hasContent((String)region)) {
                Debug.exit((Logger)logger, (String)CollectorActionHandler.class.getName(), (String)"execute");
                return null;
            }
            CintCollector cintCollector = ResourceFactory.getSingleton().getCintCollector(configurationId, region);
            CollectorAction collectorAction = new CollectorAction();
            collectorAction.setCintCollector(cintCollector);
            collectorAction.setId(action);
            collectorAction.run();
            Debug.exit((Logger)logger, (String)CollectorActionHandler.class.getName(), (String)"execute");
            return configurationId;
        }
        Debug.exit((Logger)logger, (String)CollectorActionHandler.class.getName(), (String)"execute");
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

