/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.composites;

import com.ibm.cics.dbfunc.model.Clause;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.Values;
import com.ibm.cics.ia.ui.composites.ExpressionComposite;
import com.ibm.cics.ia.ui.composites.Messages;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class QueryUsecountComposite
extends ExpressionComposite {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Button gtButton;
    private Button ltButton;
    private Button eqButton;
    private Spinner usecountSpinner;
    private Combo comparison;
    private Text useCountText;
    private int enteredNumber;
    private boolean inError;

    @Override
    public Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        composite.setLayout((Layout)gridLayout);
        Label l = new Label(composite, 0);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        l.setLayoutData((Object)data);
        l = new Label(composite, 0);
        data = new GridData();
        data.horizontalSpan = 2;
        l.setLayoutData((Object)data);
        this.comparison = new Combo(composite, 2056);
        this.comparison.add(Messages.getString("QueryUsecountComposite.comp.islessthan"));
        this.comparison.add(Messages.getString("QueryUsecountComposite.comp.isgreaterthan"));
        this.comparison.add(Messages.getString("QueryUsecountComposite.comp.is"));
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Combo combo = (Combo)e.getSource();
                QueryUsecountComposite.this.refreshForComboSelection(combo.getSelectionIndex());
            }
        };
        this.comparison.addSelectionListener((SelectionListener)selectionListener);
        this.useCountText = new Text(composite, 2048);
        this.useCountText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    int temp = Integer.parseInt(QueryUsecountComposite.this.useCountText.getText());
                    if (temp < 0) {
                        this.updateForError();
                        return;
                    }
                    QueryUsecountComposite.this.enteredNumber = temp;
                    QueryUsecountComposite.this.refreshForText(Integer.toString(QueryUsecountComposite.this.enteredNumber));
                    QueryUsecountComposite.this.clearError();
                }
                catch (NumberFormatException ee) {
                    this.updateForError();
                }
            }

            private void updateForError() {
                QueryUsecountComposite.this.setError(MessageFormat.format(Messages.getString("QueryUsecountComposite.rangeError"), Integer.MAX_VALUE));
            }
        });
        return composite;
    }

    protected void setError(String errorMessage) {
        this.inError = true;
        this.notifyErrorListeners(errorMessage);
    }

    protected void clearError() {
        if (this.inError) {
            this.inError = false;
            this.notifyErrorListeners(null);
        }
    }

    protected void notifyErrorListeners(String errorMessage) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ExpressionComposite.Listener)iter.next()).setError(errorMessage);
        }
    }

    protected void refreshForText(Object value) {
        String fieldName = "";
        ColumnReference column = (ColumnReference)((Clause)this.constraint).getColumns().get(0);
        Comparator comparator = ((Clause)this.constraint).getComparator();
        boolean isNot = ((Clause)this.constraint).isNot();
        Object[] values = new Object[]{Integer.parseInt(value.toString())};
        Clause newClause = PresentationFactory.getInstance().createSimpleCondition(column, comparator, values, isNot);
        this.constraint = newClause;
        this.notifyListeners();
    }

    protected void refreshForSpinner() {
        String fieldName = "";
        ColumnReference column = (ColumnReference)((Clause)this.constraint).getColumns().get(0);
        Comparator comparator = ((Clause)this.constraint).getComparator();
        boolean isNot = ((Clause)this.constraint).isNot();
        Object[] values = new Object[]{this.usecountSpinner.getSelection()};
        Clause newClause = PresentationFactory.getInstance().createSimpleCondition(column, comparator, values, isNot);
        this.constraint = newClause;
        this.notifyListeners();
    }

    protected void refreshForComboSelection(int selection) {
        Comparator comparator = Comparator.EQ;
        if (selection == 0) {
            comparator = Comparator.LT;
        } else if (selection == 1) {
            comparator = Comparator.GT;
        }
        Clause clause = (Clause)this.constraint;
        List valuesList = clause.getValues();
        Values values = (Values)valuesList.get(0);
        Object[] newValues = new Object[]{values.getValue()};
        Clause newClause = PresentationFactory.getInstance().createSimpleCondition((ColumnReference)clause.getColumns().get(0), comparator, newValues, clause.isNot());
        this.constraint = newClause;
        this.notifyListeners();
    }

    @Override
    public void reset() {
        this.comparison.select(2);
    }

    @Override
    public void initialize() {
        this.reset();
        Clause clause = (Clause)this.constraint;
        if (clause.getComparator().equals((Object)Comparator.EQ)) {
            this.comparison.select(2);
        } else if (clause.getComparator().equals((Object)Comparator.LT)) {
            this.comparison.select(0);
        } else {
            this.comparison.select(1);
        }
        List valuesList = clause.getValues();
        Values values = (Values)valuesList.get(0);
        int value = 0;
        try {
            value = Integer.parseInt(values.getValue().toString());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.useCountText.setText(Integer.toString(value));
    }
}

