/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.composites;

import com.ibm.cics.dbfunc.model.Clause;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.Values;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.composites.ExpressionComposite;
import com.ibm.cics.ia.ui.composites.Messages;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class QueryTimeOfDayComposite
extends ExpressionComposite {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Combo comparison;
    private Text numberField;
    private Combo timeUnit;
    private String error;
    private BigDecimal valueMs;

    @Override
    public Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 0, false, false);
        this.comparison = new Combo(composite, 2056);
        this.comparison.add(com.ibm.cics.ia.query.Messages.getString((String)"FieldExpression.is"));
        this.comparison.add(com.ibm.cics.ia.query.Messages.getString((String)"FieldExpression.isGreaterOrEqual"));
        this.comparison.add(com.ibm.cics.ia.query.Messages.getString((String)"FieldExpression.isLessOrEqual"));
        this.comparison.add(com.ibm.cics.ia.query.Messages.getString((String)"FieldExpression.isLess"));
        this.comparison.add(com.ibm.cics.ia.query.Messages.getString((String)"FieldExpression.isGreater"));
        this.comparison.add(com.ibm.cics.ia.query.Messages.getString((String)"FieldExpression.isNot"));
        this.comparison.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Clause clause = (Clause)QueryTimeOfDayComposite.this.constraint;
                Comparator comparator = null;
                if (QueryTimeOfDayComposite.this.comparison.getSelectionIndex() < 5) {
                    comparator = Comparator.values()[QueryTimeOfDayComposite.this.comparison.getSelectionIndex()];
                    clause.setNot(false);
                } else {
                    comparator = Comparator.EQ;
                    clause.setNot(true);
                }
                List valuesList = clause.getValues();
                Values values = (Values)valuesList.get(0);
                Object[] newValues = new Object[]{values.getValue()};
                QueryTimeOfDayComposite.this.constraint = PresentationFactory.getInstance().createSimpleCondition((ColumnReference)clause.getColumns().get(0), comparator, newValues, clause.isNot());
                QueryTimeOfDayComposite.this.notifyListeners();
            }
        });
        this.comparison.select(0);
        this.comparison.setLayoutData((Object)data);
        this.numberField = new Text(composite, 2048);
        this.numberField.setLayoutData((Object)data);
        this.numberField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BigDecimal currentMax = IAUtilities.MAX_TOD_MS.movePointRight((QueryTimeOfDayComposite.this.timeUnit.getSelectionIndex() - 1) * 3);
                BigDecimal currentMin = IAUtilities.MIN_TOD_MS.movePointRight((QueryTimeOfDayComposite.this.timeUnit.getSelectionIndex() - 1) * 3);
                String trimmedText = QueryTimeOfDayComposite.this.numberField.getText().trim();
                ColumnReference column = (ColumnReference)((Clause)QueryTimeOfDayComposite.this.constraint).getColumns().get(0);
                Comparator comparator = ((Clause)QueryTimeOfDayComposite.this.constraint).getComparator();
                boolean isNot = ((Clause)QueryTimeOfDayComposite.this.constraint).isNot();
                if (trimmedText.isEmpty()) {
                    QueryTimeOfDayComposite.this.valueMs = BigDecimal.ZERO;
                    Object[] values = new Object[]{"00000000000000000000"};
                    QueryTimeOfDayComposite.this.constraint = PresentationFactory.getInstance().createSimpleCondition(column, comparator, values, isNot);
                    QueryTimeOfDayComposite.this.error = null;
                } else {
                    try {
                        QueryTimeOfDayComposite.this.valueMs = new BigDecimal(trimmedText.replaceAll(",", "\\."));
                        if (QueryTimeOfDayComposite.this.valueMs.compareTo(currentMin) >= 0 && QueryTimeOfDayComposite.this.valueMs.compareTo(currentMax) <= 0) {
                            QueryTimeOfDayComposite.this.valueMs = QueryTimeOfDayComposite.this.valueMs.movePointLeft((QueryTimeOfDayComposite.this.timeUnit.getSelectionIndex() - 1) * 3);
                            Object[] values = new Object[]{IAUtilities.getTodString((BigDecimal)QueryTimeOfDayComposite.this.valueMs)[0]};
                            QueryTimeOfDayComposite.this.constraint = PresentationFactory.getInstance().createSimpleCondition(column, comparator, values, isNot);
                            QueryTimeOfDayComposite.this.error = null;
                        } else {
                            QueryTimeOfDayComposite.this.error = MessageFormat.format(Messages.getString("DecimalNumber.rangeErrorInclusive"), currentMin.toPlainString(), currentMax.toPlainString());
                        }
                    }
                    catch (NumberFormatException ex) {
                        QueryTimeOfDayComposite.this.error = MessageFormat.format(Messages.getString("DecimalNumber.rangeErrorInclusive"), currentMin.toPlainString(), currentMax.toPlainString());
                    }
                }
                QueryTimeOfDayComposite.this.notifyListeners();
            }
        });
        this.timeUnit = new Combo(composite, 2056);
        this.timeUnit.add(com.ibm.cics.ia.query.Messages.getString((String)"TimeUnit.second"));
        this.timeUnit.add(com.ibm.cics.ia.query.Messages.getString((String)"TimeUnit.millisecond"));
        this.timeUnit.add(com.ibm.cics.ia.query.Messages.getString((String)"TimeUnit.microsecond"));
        this.timeUnit.add(com.ibm.cics.ia.query.Messages.getString((String)"TimeUnit.nanosecond"));
        this.timeUnit.setLayoutData((Object)data);
        this.timeUnit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String trimmedText = QueryTimeOfDayComposite.this.numberField.getText().trim();
                if (QueryTimeOfDayComposite.this.error == null) {
                    if (QueryTimeOfDayComposite.this.valueMs.compareTo(BigDecimal.ZERO) != 0) {
                        QueryTimeOfDayComposite.this.numberField.setText(QueryTimeOfDayComposite.this.valueMs.movePointRight((QueryTimeOfDayComposite.this.timeUnit.getSelectionIndex() - 1) * 3).toPlainString());
                    }
                } else {
                    QueryTimeOfDayComposite.this.numberField.setText(QueryTimeOfDayComposite.this.numberField.getText());
                }
                QueryTimeOfDayComposite.this.notifyListeners();
            }
        });
        return composite;
    }

    @Override
    public void initialize() {
        this.timeUnit.select(1);
        Clause clause = (Clause)this.constraint;
        List valuesList = clause.getValues();
        Values values = (Values)valuesList.get(0);
        try {
            String value = values.getValue().toString();
            this.valueMs = value.isEmpty() ? BigDecimal.ZERO : IAUtilities.getTodMilliseconds((String)value);
        }
        catch (NumberFormatException e) {
            this.valueMs = BigDecimal.ZERO;
        }
        this.numberField.setText(this.valueMs.compareTo(BigDecimal.ZERO) == 0 ? "" : this.valueMs.toPlainString());
        this.comparison.select(clause.isNot() ? 5 : clause.getComparator().ordinal());
    }

    @Override
    protected void notifyListeners() {
        for (Object listener : this.listeners) {
            ((ExpressionComposite.Listener)listener).expressionChanged(this.constraint);
            ((ExpressionComposite.Listener)listener).setError(this.error);
        }
    }
}

