/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.composites;

import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.ICredentialsManager;
import com.ibm.cics.dbfunc.model.Clause;
import com.ibm.cics.dbfunc.model.ClauseGroup;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.ConstraintElement;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.Values;
import com.ibm.cics.eclipse.common.ui.EnsureUppercaseListener;
import com.ibm.cics.ia.query.SQLDefinitions;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.composites.ExpressionComposite;
import com.ibm.cics.ia.ui.composites.Messages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class QueryEditableUserIdTableComposite
extends ExpressionComposite {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String TEXT_CONTROL = "TEXT_CONTROL";
    private static final String TABLE_ITEM = "TABLE_ITEM";
    private Table programTable;
    private ToolItem toolItem;
    private Button columnButton;
    private Button tableButton;
    private List tableTextItems = new ArrayList();
    private Label columnLabel;
    private String selectedColumn;

    @Override
    public Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 1;
        composite.setLayout((Layout)gridLayout);
        final ToolBar toolBar = new ToolBar(composite, 0x820000);
        GridData data = new GridData(4, 0x1000000, true, false);
        toolBar.setLayoutData((Object)data);
        this.toolItem = new ToolItem(toolBar, 0x800004);
        this.toolItem.setToolTipText(Messages.getString("QueryCheckboxTableComposite.toolItem.toolTipText"));
        this.toolItem.setText(Messages.getString("QueryCheckboxTableComposite.button.isnot"));
        this.toolItem.setImage(ImageFactory.getNotEqualImage());
        int typeWidth = this.toolItem.getBounds().width;
        data = new GridData(4, 0x1000000, true, false);
        data.minimumWidth = typeWidth;
        toolBar.setLayoutData((Object)data);
        this.toolItem.setText(Messages.getString("QueryCheckboxTableComposite.button.is"));
        this.toolItem.setImage(ImageFactory.getEqualImage());
        final Menu menu = new Menu((Decorations)composite.getShell(), 8);
        this.toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Rectangle rect = QueryEditableUserIdTableComposite.this.toolItem.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = toolBar.toDisplay(pt);
                menu.setLocation(pt.x, pt.y);
                menu.setVisible(true);
            }
        });
        MenuItem isMenuItem = new MenuItem(menu, 8);
        isMenuItem.setText(Messages.getString("QueryCheckboxTableComposite.button.is"));
        isMenuItem.setImage(ImageFactory.getEqualImage());
        isMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryEditableUserIdTableComposite.this.setIs(true);
            }
        });
        MenuItem isNotMenuItem = new MenuItem(menu, 8);
        isNotMenuItem.setText(Messages.getString("QueryCheckboxTableComposite.button.isnot"));
        isNotMenuItem.setImage(ImageFactory.getNotEqualImage());
        isNotMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryEditableUserIdTableComposite.this.setIs(false);
            }
        });
        data = new GridData(4, 4, true, true);
        if (this.hasEquivalentColumns()) {
            List equivalentColumns = this.getEquivalentColumns();
            final Composite c = new Composite(composite, 0);
            GridData data2 = new GridData(4, 0x1000000, true, false);
            c.setLayout((Layout)new GridLayout(2, false));
            c.setLayoutData((Object)data2);
            this.columnButton = new Button(c, 16);
            data2 = new GridData(16384, 0x1000000, false, false);
            this.columnButton.setLayoutData((Object)data2);
            if (equivalentColumns.size() == 1) {
                String column;
                this.selectedColumn = column = (String)equivalentColumns.get(0);
                Label columnButtonLabel = new Label(c, 0);
                columnButtonLabel.setText(SQLDefinitions.getColumnDescription((String)column));
                this.columnButton.setData((Object)column);
            } else {
                final ToolBar columnToolBar = new ToolBar(c, 0x800000);
                data2 = new GridData(16384, 4, true, false);
                columnToolBar.setLayoutData((Object)data2);
                final ToolItem columnToolItem = new ToolItem(columnToolBar, 4);
                columnToolItem.setToolTipText(Messages.getString("QueryEditableTableComposite.columnLabel.text"));
                columnToolItem.setText(SQLDefinitions.getColumnDescription((String)((String)equivalentColumns.get(0))));
                final Menu columnMenu = new Menu((Decorations)c.getShell(), 8);
                columnToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        Rectangle rect = columnToolItem.getBounds();
                        Point pt = new Point(rect.x, rect.y + rect.height);
                        pt = c.toDisplay(pt);
                        columnMenu.setLocation(pt.x, pt.y);
                        columnMenu.setVisible(true);
                    }
                });
                for (String column : equivalentColumns) {
                    final MenuItem menuItem = new MenuItem(columnMenu, 8);
                    menuItem.setText(SQLDefinitions.getColumnDescription((String)column));
                    menuItem.setData((Object)column);
                    menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ClauseGroup clauses;
                            Clause clause;
                            QueryEditableUserIdTableComposite.this.selectedColumn = (String)menuItem.getData();
                            columnToolItem.setText(menuItem.getText());
                            columnToolBar.pack();
                            columnToolBar.layout();
                            columnToolBar.getParent().layout(true);
                            QueryEditableUserIdTableComposite.this.columnButton.setSelection(true);
                            QueryEditableUserIdTableComposite.this.tableButton.setSelection(false);
                            QueryEditableUserIdTableComposite.this.setTableEnablement(false);
                            boolean is = false;
                            is = QueryEditableUserIdTableComposite.this.constraint instanceof Clause ? !(clause = (Clause)QueryEditableUserIdTableComposite.this.constraint).isNot() : !((Clause)(clauses = (ClauseGroup)QueryEditableUserIdTableComposite.this.constraint).getClauses().get(0)).isNot();
                            QueryEditableUserIdTableComposite.this.recalculateFromSelection(QueryEditableUserIdTableComposite.this.selectedColumn, is);
                        }
                    });
                }
            }
            this.columnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (QueryEditableUserIdTableComposite.this.columnButton.getSelection()) {
                        ClauseGroup clauses;
                        Clause clause;
                        boolean is = false;
                        is = QueryEditableUserIdTableComposite.this.constraint instanceof Clause ? !(clause = (Clause)QueryEditableUserIdTableComposite.this.constraint).isNot() : !((Clause)(clauses = (ClauseGroup)QueryEditableUserIdTableComposite.this.constraint).getClauses().get(0)).isNot();
                        QueryEditableUserIdTableComposite.this.recalculateFromSelection(QueryEditableUserIdTableComposite.this.selectedColumn, is);
                        QueryEditableUserIdTableComposite.this.setTableEnablement(false);
                    }
                }
            });
            this.tableButton = new Button(c, 16);
            Label tableButtonLabel = new Label(c, 0);
            tableButtonLabel.setText(Messages.getString("QueryEditableTableComposite.tableButtonLabel.text"));
            this.tableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (QueryEditableUserIdTableComposite.this.tableButton.getSelection()) {
                        ClauseGroup clauses;
                        Clause clause;
                        boolean is = false;
                        is = QueryEditableUserIdTableComposite.this.constraint instanceof Clause ? !(clause = (Clause)QueryEditableUserIdTableComposite.this.constraint).isNot() : !((Clause)(clauses = (ClauseGroup)QueryEditableUserIdTableComposite.this.constraint).getClauses().get(0)).isNot();
                        QueryEditableUserIdTableComposite.this.recalculateFromEditableTable(QueryEditableUserIdTableComposite.this.programTable, is);
                        QueryEditableUserIdTableComposite.this.setTableEnablement(true);
                    }
                }
            });
            data.horizontalIndent = 20;
        }
        this.programTable = new Table(composite, 2052);
        this.programTable.setLayoutData((Object)data);
        this.programTable.setLinesVisible(true);
        final TableColumn column = new TableColumn(this.programTable, 0);
        column.setWidth(this.programTable.getSize().x);
        this.programTable.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                Rectangle area = QueryEditableUserIdTableComposite.this.programTable.getClientArea();
                column.setWidth(area.width);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        return composite;
    }

    protected void recalculateFromSelection(String selection, boolean is) {
        String fieldName = "";
        ColumnReference column = null;
        if (this.constraint instanceof Clause) {
            column = (ColumnReference)((Clause)this.constraint).getColumns().get(0);
        } else {
            ClauseGroup clauses = (ClauseGroup)this.constraint;
            Clause clause = (Clause)clauses.getClauses().get(0);
            column = (ColumnReference)clause.getColumns().get(0);
        }
        Clause newClause = null;
        Object[] values = new Object[]{selection};
        newClause = PresentationFactory.getInstance().createSimpleCondition(column, Comparator.EQ, values, !is);
        this.constraint = newClause;
        this.notifyListeners();
    }

    protected void setTableEnablement(boolean b) {
        this.programTable.setEnabled(b);
        Iterator iterator = this.tableTextItems.iterator();
        while (iterator.hasNext()) {
            ((Text)iterator.next()).setEnabled(b);
        }
    }

    private void setIs(boolean b) {
        String menuText = b ? Messages.getString("QueryEditableTableComposite.QueryEditableTableComposite.button.is") : Messages.getString("QueryEditableTableComposite.QueryEditableTableComposite.button.isnot");
        this.toolItem.setText(menuText);
        Image image = b ? ImageFactory.getEqualImage() : ImageFactory.getNotEqualImage();
        this.toolItem.setImage(image);
        if (this.programTable.isEnabled()) {
            this.recalculateFromEditableTable(this.programTable, b);
        } else {
            this.recalculateFromSelection(this.selectedColumn, b);
        }
    }

    @Override
    public void initialize() {
        ClauseGroup clauses;
        Clause clause;
        int numberOfItems;
        this.tableTextItems.clear();
        TableItem[] tableItems = this.programTable.getItems();
        if (this.columnButton != null && this.tableButton != null) {
            this.columnButton.setSelection(false);
            this.tableButton.setSelection(true);
        }
        this.setTableEnablement(true);
        int i = 0;
        while (i < tableItems.length) {
            ((Text)tableItems[i].getData(TEXT_CONTROL)).dispose();
            tableItems[i].dispose();
            ++i;
        }
        if (this.constraint instanceof Clause) {
            Clause clause2 = (Clause)this.constraint;
            List valuesList = clause2.getValues();
            Values values = (Values)valuesList.get(0);
            Object value = values.getValue();
            if (value instanceof String) {
                IConnectable iConnectable;
                if (((String)value).equals("") && (iConnectable = ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.ia.connection.db2")).getConnection() != null) {
                    ICredentialsManager mgr = ConnectionsPlugin.getDefault().getConnectionService().getConnectionManager().getCredentialsManager();
                    CredentialsConfiguration credentials = mgr.findCredentialsConfigurationByID(iConnectable.getConnection().getConfiguration().getCredentialsID());
                    value = credentials.getUserID();
                }
                String programName = (String)value;
                this.createTableItem(programName);
            } else if (value instanceof String[]) {
                Iterator iter = ((List)value).iterator();
                while (iter.hasNext()) {
                    this.createTableItem((String)iter.next());
                }
            }
        } else {
            List constraints = ((ClauseGroup)this.constraint).getClauses();
            for (ConstraintElement element : constraints) {
                if (!(element instanceof Clause)) continue;
                Clause clause3 = (Clause)element;
                List valuesList = clause3.getValues();
                Values values = (Values)valuesList.get(0);
                Object value = values.getValue();
                if (value instanceof String) {
                    String programName = (String)value;
                    this.createTableItem(programName);
                    continue;
                }
                if (!(value instanceof String[])) continue;
                String[] stringArray = (String[])value;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String v = stringArray[n2];
                    this.createTableItem(v);
                    ++n2;
                }
            }
        }
        int i2 = numberOfItems = this.programTable.getItemCount();
        while (i2 < 25) {
            this.createTableItem(null);
            ++i2;
        }
        this.setTableEnablement(true);
        boolean is = false;
        is = this.constraint instanceof Clause ? !(clause = (Clause)this.constraint).isNot() : !((Clause)(clauses = (ClauseGroup)this.constraint).getClauses().get(0)).isNot();
        this.setIs(is);
    }

    private void createTableItem(String programName) {
        final TableItem newItem = new TableItem(this.programTable, 0);
        if (programName != null) {
            newItem.setText(programName);
            newItem.setData((Object)programName);
        }
        TableEditor tableEditor = new TableEditor(this.programTable);
        tableEditor.grabHorizontal = true;
        final Text programItemText = new Text((Composite)this.programTable, 0);
        EnsureUppercaseListener.attach((Text)programItemText);
        programItemText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
            }
        });
        programItemText.setData(TABLE_ITEM, (Object)newItem);
        if (programName != null) {
            programItemText.setText(programName);
            programItemText.setData((Object)programName);
        }
        newItem.setData(TEXT_CONTROL, (Object)programItemText);
        tableEditor.setEditor((Control)programItemText, newItem, 0);
        programItemText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ClauseGroup clauses;
                Clause clause;
                newItem.setData((Object)programItemText.getText());
                boolean is = false;
                is = QueryEditableUserIdTableComposite.this.constraint instanceof Clause ? !(clause = (Clause)QueryEditableUserIdTableComposite.this.constraint).isNot() : !((Clause)(clauses = (ClauseGroup)QueryEditableUserIdTableComposite.this.constraint).getClauses().get(0)).isNot();
                QueryEditableUserIdTableComposite.this.recalculateFromEditableTable(QueryEditableUserIdTableComposite.this.programTable, is);
            }
        });
        this.tableTextItems.add(programItemText);
    }
}

