/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.composites;

import com.ibm.cics.dbfunc.model.Clause;
import com.ibm.cics.dbfunc.model.ClauseGroup;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.ConstraintElement;
import com.ibm.cics.ia.ui.composites.QueryEditableTableComposite;
import java.util.ArrayList;
import java.util.List;

public class QueryEditableTableColumnComposite
extends QueryEditableTableComposite {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static ArrayList allEquivalentcolumns = new ArrayList();
    private ArrayList columns;

    static {
        allEquivalentcolumns.add("PROGRAM");
        allEquivalentcolumns.add("TRANSID");
        allEquivalentcolumns.add("OBJECT");
        allEquivalentcolumns.add("RESNAME");
        allEquivalentcolumns.add("RESOURCE_NAME");
        allEquivalentcolumns.add("APPLID");
    }

    @Override
    protected boolean hasEquivalentColumns() {
        if (this.constraint instanceof Clause) {
            Clause clause = (Clause)this.constraint;
            return allEquivalentcolumns.contains(((ColumnReference)clause.getColumns().get(0)).getColumnName());
        }
        ClauseGroup clauseGroup = (ClauseGroup)this.constraint;
        List constraints = clauseGroup.getClauses();
        boolean b = true;
        for (ConstraintElement constraintElement : constraints) {
            if (!(constraintElement instanceof Clause)) continue;
            Clause clause = (Clause)constraintElement;
            b &= allEquivalentcolumns.contains(((ColumnReference)clause.getColumns().get(0)).getColumnName());
        }
        return b;
    }

    @Override
    protected List getEquivalentColumns() {
        if (this.constraint instanceof Clause) {
            Clause clause = (Clause)this.constraint;
            this.columns = this.getEquivalentColumns(clause);
            return this.columns;
        }
        ClauseGroup clauseGroup = (ClauseGroup)this.constraint;
        List constraintList = clauseGroup.getClauses();
        for (ConstraintElement constraintElement : constraintList) {
            if (!(constraintElement instanceof Clause)) continue;
            Clause clause = (Clause)constraintElement;
            this.columns = this.getEquivalentColumns(clause);
        }
        return this.columns;
    }

    private ArrayList getEquivalentColumns(Clause clause) {
        if (this.columns == null) {
            this.columns = new ArrayList();
            if (((ColumnReference)clause.getColumns().get(0)).getColumnName().equals("RESOURCE_NAME") || ((ColumnReference)clause.getColumns().get(0)).getColumnName().equals("OBJECT") || ((ColumnReference)clause.getColumns().get(0)).getColumnName().equals("RESNAME")) {
                this.columns.add("PROGRAM");
                this.columns.add("TRANSID");
                this.columns.add("APPLID");
            } else if (((ColumnReference)clause.getColumns().get(0)).getColumnName().equals("PROGRAM") || ((ColumnReference)clause.getColumns().get(0)).getColumnName().equals("TRANSID") || ((ColumnReference)clause.getColumns().get(0)).getColumnName().equals("APPLID")) {
                if (this.tableType.equals("com.ibm.cics.query.type.db2")) {
                    this.columns.add("RESNAME");
                } else if (this.tableType.equals("com.ibm.cics.query.type.commandflow")) {
                    this.columns.add("RESOURCE_NAME");
                } else {
                    this.columns.add("OBJECT");
                }
            }
        }
        return this.columns;
    }
}

