/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.composites;

import com.ibm.cics.dbfunc.model.Clause;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.Values;
import com.ibm.cics.ia.ui.composites.ExpressionComposite;
import com.ibm.cics.ia.ui.composites.Messages;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;

public class QueryBooleanComposite
extends ExpressionComposite {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Button yesButton;
    private Button noButton;

    @Override
    public Composite createComposite(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginLeft = 5;
        c.setLayout((Layout)gridLayout);
        new ToolBar(c, 0);
        this.yesButton = new Button(c, 16);
        this.yesButton.setData((Object)"Y");
        this.yesButton.setText(Messages.getString("QueryBooleanComposite.button.yes"));
        this.noButton = new Button(c, 16);
        this.noButton.setData((Object)"N");
        this.noButton.setText(Messages.getString("QueryBooleanComposite.button.no"));
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                if (button.getSelection()) {
                    QueryBooleanComposite.this.refreshForSelectedButton(button);
                }
            }
        };
        this.yesButton.addSelectionListener((SelectionListener)selectionListener);
        this.noButton.addSelectionListener((SelectionListener)selectionListener);
        return c;
    }

    private void refreshForSelectedButton(Button aButton) {
        if (this.constraint instanceof Clause) {
            Clause clause = (Clause)this.constraint;
            ColumnReference column = (ColumnReference)clause.getColumns().get(0);
            Object[] values = new Object[]{(String)aButton.getData()};
            Clause newClause = PresentationFactory.getInstance().createSimpleCondition(column, Comparator.EQ, values, false);
            this.constraint = newClause;
            this.notifyListeners();
        }
    }

    @Override
    public void initialize() {
        if (this.constraint instanceof Clause) {
            Clause clause = (Clause)this.constraint;
            List valuesList = clause.getValues();
            Values values = (Values)valuesList.get(0);
            String value = values.getValue().toString();
            if (value != null) {
                if ("Y".equals(value)) {
                    this.yesButton.setSelection(true);
                    this.noButton.setSelection(false);
                } else if ("N".equals(value)) {
                    this.noButton.setSelection(true);
                    this.yesButton.setSelection(false);
                } else {
                    value = "Y";
                    this.yesButton.setSelection(true);
                    this.noButton.setSelection(false);
                    this.refreshForSelectedButton(this.yesButton);
                }
            } else {
                this.yesButton.setSelection(true);
                this.noButton.setSelection(false);
                this.refreshForSelectedButton(this.yesButton);
            }
        }
    }
}

