/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.composites;

import com.ibm.cics.ia.ui.Messages;
import java.text.MessageFormat;

public class PropertyValidator {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private int maxLength = -1;
    private boolean validateMaxLength = false;
    private boolean validateCharacters = false;
    private boolean validateStartsWith = false;
    private boolean validateCantStartWithDigit = false;
    private boolean validateMax1Wildcard = false;
    private boolean validateEmbeddedBlanks = false;
    private boolean validateEmptyness = false;
    private boolean validatePositiveInteger = false;
    private String allowedCharacters;
    private String allowedFirstCharacters;
    private String prohibitedFirstCharacters;
    private static final String UPPERCASE_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String LOWERCASE_CHARS = "abcdefghijklmnopqrstuvwxyz";
    private static final String DIGITS = "0123456789";
    private static final String TRANSACTION_SPECIFC_CHARS = "$@#./-_%&?!:|\"=?,;<>";
    private static final String PROGRAM_SPECIFIC_CHARS = "@#$";
    private static final String WILDCARD_CHAR = "*";
    private static final char SPACE = ' ';
    private String errorMessage;
    private String key;

    public PropertyValidator(String key) {
        this.key = key;
        if (key.contains("applid")) {
            this.validateMaxLength = true;
            this.validateCharacters = true;
            this.validateStartsWith = true;
            this.validateEmbeddedBlanks = true;
            this.maxLength = 8;
            this.allowedCharacters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
            this.allowedFirstCharacters = UPPERCASE_CHARS;
        } else if (key.contains("exitname")) {
            this.validateMaxLength = true;
            this.validateCharacters = true;
            this.validateStartsWith = true;
            this.validateEmbeddedBlanks = true;
            this.maxLength = 8;
            this.allowedCharacters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
            this.allowedFirstCharacters = UPPERCASE_CHARS;
        } else if (key.contains("cmdflowid")) {
            this.validateMaxLength = true;
            this.validateCharacters = true;
            this.validateStartsWith = true;
            this.validateEmbeddedBlanks = true;
            this.maxLength = 8;
            this.allowedCharacters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
            this.allowedFirstCharacters = UPPERCASE_CHARS;
        } else if (key.contains("termid")) {
            this.validateMaxLength = true;
            this.validateCharacters = true;
            this.validateStartsWith = true;
            this.validateMax1Wildcard = true;
            this.validateEmbeddedBlanks = true;
            this.maxLength = 4;
            this.allowedCharacters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789*";
            this.allowedFirstCharacters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ*";
        } else if (key.equals("tran1") || key.equals("tran2") || key.equals("tran3") || key.equals("tran4") || key.equals("tran5")) {
            this.maxLength = 4;
            this.validateCantStartWithDigit = true;
            this.validateMaxLength = true;
            this.validateMax1Wildcard = true;
            this.validateEmbeddedBlanks = true;
            this.validateCharacters = true;
            this.allowedCharacters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789$@#./-_%&?!:|\"=?,;<>*";
        } else if (key.equals("max_task")) {
            this.validatePositiveInteger = true;
            this.validateMaxLength = true;
            this.maxLength = 4;
        } else if (key.equals("max_recs")) {
            this.validatePositiveInteger = true;
            this.validateMaxLength = true;
            this.maxLength = 7;
        } else if (key.equals("prog_exlist_name") || key.equals("tran_exlist_name") || key.equals("comm_inlist_name")) {
            this.validateMaxLength = true;
            this.validateCharacters = true;
            this.maxLength = 8;
            this.allowedCharacters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789@#$";
        }
    }

    public boolean validateInput(String inputString) {
        String str;
        int index;
        String firstChar;
        if (this.validateMaxLength && this.maxLength > -1 && inputString.length() > this.maxLength) {
            this.errorMessage = MessageFormat.format(Messages.getString("CollectorOptionsEditor.invalid.text.tooLong"), Messages.getString("CollectorOptionsEditor.Property." + this.key));
            return false;
        }
        if (this.validateStartsWith && inputString.length() > 0) {
            firstChar = inputString.substring(0, 1);
            if (this.allowedFirstCharacters != null && !this.allowedFirstCharacters.contains(firstChar)) {
                this.errorMessage = MessageFormat.format(Messages.getString("CollectorOptionsEditor.invalid.text.startswith.invalid"), Messages.getString("CollectorOptionsEditor.Property." + this.key), firstChar);
                return false;
            }
            if (this.prohibitedFirstCharacters != null && this.prohibitedFirstCharacters.contains(firstChar)) {
                this.errorMessage = MessageFormat.format(Messages.getString("CollectorOptionsEditor.invalid.text.startswith.invalid"), Messages.getString("CollectorOptionsEditor.Property." + this.key), firstChar);
                return false;
            }
        }
        if (this.validateCharacters && inputString.length() > 0) {
            int i = 0;
            while (i < inputString.length()) {
                String substr = inputString.substring(i, i + 1);
                if (!this.allowedCharacters.contains(substr)) {
                    this.errorMessage = MessageFormat.format(Messages.getString("CollectorOptionsEditor.invalid.text.invalid.characters"), Messages.getString("CollectorOptionsEditor.Property." + this.key));
                    return false;
                }
                ++i;
            }
        }
        if (this.validateCantStartWithDigit && inputString.length() > 0 && DIGITS.contains(firstChar = inputString.substring(0, 1))) {
            this.errorMessage = MessageFormat.format(Messages.getString("CollectorOptionsEditor.invalid.text.startswith.invalid"), Messages.getString("CollectorOptionsEditor.Property." + this.key), firstChar);
            return false;
        }
        if (this.validateMax1Wildcard && inputString.length() > 0 && (index = inputString.indexOf(42)) >= 0 && inputString.indexOf(42, index + 1) != -1) {
            this.errorMessage = MessageFormat.format(Messages.getString("CollectorOptionsEditor.invalid.text.invalid.wildcards"), Messages.getString("CollectorOptionsEditor.Property." + this.key));
            return false;
        }
        if (this.validateEmbeddedBlanks && inputString.length() > 0 && (str = inputString.trim()).indexOf(" ") != -1) {
            this.errorMessage = MessageFormat.format(Messages.getString("CollectorOptionsEditor.invalid.text.invalid.embedded.blanks"), Messages.getString("CollectorOptionsEditor.Property." + this.key));
            return false;
        }
        if (this.validateEmptyness && inputString.length() == 0) {
            this.errorMessage = MessageFormat.format(Messages.getString("CollectorOptionsEditor.invalid.text.empty"), Messages.getString("CollectorOptionsEditor.Property." + this.key));
            return false;
        }
        if (this.validatePositiveInteger && inputString.length() > 0) {
            Integer result = null;
            try {
                result = Integer.parseInt(inputString);
            }
            catch (NumberFormatException ex) {
                this.errorMessage = MessageFormat.format(Messages.getString("CollectorOptionsEditor.invalid.text.not.integer"), Messages.getString("CollectorOptionsEditor.Property." + this.key));
                return false;
            }
            if (result < 0) {
                this.errorMessage = MessageFormat.format(Messages.getString("CollectorOptionsEditor.invalid.text.negative"), Messages.getString("CollectorOptionsEditor.Property." + this.key));
                return false;
            }
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

