/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.composites;

import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.composites.HistoryBoxModel;
import com.ibm.cics.ia.ui.composites.Messages;
import java.util.LinkedList;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class HistoryBox
extends Composite {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Text edLine;
    private Button btnDown;
    private List lbxHistory;
    private boolean assignText = false;
    private int itemsMaxCount;
    LinkedList<String> items;
    private Composite parent;
    private Point size;
    private ConnectionServiceListener connectionServiceListener = new ConnectionServiceListener(){

        public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
            if ("com.ibm.cics.ia.connection.db2".equals(event.getConnectionCategoryId()) && event instanceof ConnectionServiceListener.DisconnectedEvent) {
                HistoryBox.this.clear();
            }
        }
    };

    private void loadFullList() {
        this.lbxHistory.removeAll();
        int i = 0;
        while (i < this.items.size()) {
            if (this.items.get(i) != null) {
                this.lbxHistory.add(this.items.get(i));
            }
            ++i;
        }
    }

    private void setHistoryVisible(boolean isVisible) {
        if (this.lbxHistory != null && !this.lbxHistory.isDisposed()) {
            this.lbxHistory.setParent((Composite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            this.lbxHistory.setVisible(isVisible);
            if (isVisible) {
                Point pt = this.edLine.getLocation();
                pt.y += this.edLine.getSize().y;
                Point pt2 = new Point(0, 0);
                Composite p = this.edLine.getParent();
                while (p != null) {
                    pt2 = p.getLocation();
                    pt.x += pt2.x;
                    pt.y += pt2.y;
                    p = p.getParent();
                }
                pt.x -= pt2.x;
                pt.y -= pt2.y;
                Point preferredSize = this.lbxHistory.computeSize(-1, -1);
                int historyListVertHeight = this.items.size() > 0 ? preferredSize.y : this.lbxHistory.getItemHeight();
                this.lbxHistory.setLocation(pt);
                this.lbxHistory.setSize(this.edLine.getSize().x + this.btnDown.getSize().x, historyListVertHeight);
                this.lbxHistory.moveAbove(null);
            } else {
                this.lbxHistory.setSize(0, 0);
            }
        }
    }

    public HistoryBox(Composite parent1, int maxCount) {
        super(parent1, 0);
        this.itemsMaxCount = maxCount;
        this.parent = parent1;
        this.items = new LinkedList();
        this.edLine = new Text((Composite)this, 2048);
        this.btnDown = new Button((Composite)this, 0x800404);
        this.lbxHistory = new List((Composite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 2564);
        GridLayout lt = new GridLayout(2, false);
        lt.verticalSpacing = 0;
        lt.horizontalSpacing = 0;
        lt.marginWidth = 0;
        lt.marginHeight = 0;
        this.setLayout((Layout)lt);
        GridData gridData = new GridData();
        gridData.widthHint = this.edLine.computeSize((int)-1, (int)-1).x;
        this.edLine.setLayoutData((Object)gridData);
        this.size = super.computeSize(-1, -1, true);
        this.lbxHistory.setVisible(false);
        this.btnDown.setToolTipText(Messages.getString("HistoryBox.downarrow.tooltip.prevsearch"));
        this.edLine.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean visible = HistoryBox.this.lbxHistory.getVisible();
                String s = ((Text)e.widget).getText().toUpperCase();
                HistoryBox.this.lbxHistory.removeAll();
                int i = 0;
                while (i < HistoryBox.this.items.size()) {
                    String t = HistoryBox.this.items.get(i);
                    if (t != null && t.toUpperCase().startsWith(s)) {
                        HistoryBox.this.lbxHistory.add(t);
                    }
                    ++i;
                }
                if (HistoryBox.this.assignText) {
                    HistoryBox.this.assignText = false;
                    return;
                }
                if (HistoryBox.this.lbxHistory.getItemCount() > 0) {
                    HistoryBox.this.setHistoryVisible(true);
                }
                if (HistoryBox.this.lbxHistory.getItemCount() <= 0 && visible) {
                    HistoryBox.this.setHistoryVisible(false);
                }
            }
        });
        this.edLine.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    HistoryBox.this.setHistoryVisible(false);
                }
                if (e.detail == 64 && e.keyCode == 0x1000002) {
                    if (HistoryBox.this.lbxHistory.getItemCount() > 0 && !HistoryBox.this.lbxHistory.getVisible()) {
                        HistoryBox.this.setHistoryVisible(true);
                    }
                    if (HistoryBox.this.lbxHistory.getItemCount() > 0) {
                        HistoryBox.this.lbxHistory.setSelection(0);
                    }
                    if (HistoryBox.this.lbxHistory.getVisible()) {
                        HistoryBox.this.lbxHistory.setFocus();
                    }
                }
            }
        });
        this.lbxHistory.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    int idx = HistoryBox.this.lbxHistory.getSelectionIndex();
                    if (idx == -1) {
                        return;
                    }
                    HistoryBox.this.edLine.setText(HistoryBox.this.lbxHistory.getItem(idx));
                    HistoryBox.this.setHistoryVisible(false);
                    HistoryBox.this.edLine.setFocus();
                }
                if (e.detail == 2) {
                    HistoryBox.this.setHistoryVisible(false);
                    HistoryBox.this.edLine.setFocus();
                }
            }
        });
        this.btnDown.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (!HistoryBox.this.lbxHistory.getVisible()) {
                    HistoryBox.this.loadFullList();
                }
                HistoryBox.this.setHistoryVisible(!HistoryBox.this.lbxHistory.getVisible());
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        this.lbxHistory.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                int idx = HistoryBox.this.lbxHistory.getSelectionIndex();
                if (idx == -1) {
                    return;
                }
                HistoryBox.this.edLine.setText(HistoryBox.this.lbxHistory.getItem(idx));
                HistoryBox.this.setHistoryVisible(false);
                HistoryBox.this.edLine.setFocus();
            }

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.lbxHistory.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                HistoryBox.this.setHistoryVisible(false);
            }
        });
        this.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                HistoryBox.this.parent.getDisplay().timerExec(100, new Runnable(){

                    @Override
                    public void run() {
                        if (!HistoryBox.this.lbxHistory.isDisposed() && HistoryBox.this.lbxHistory.isFocusControl()) {
                            return;
                        }
                        if (!HistoryBox.this.edLine.isDisposed() && HistoryBox.this.edLine.isFocusControl()) {
                            return;
                        }
                        if (!HistoryBox.this.btnDown.isDisposed() && HistoryBox.this.btnDown.isFocusControl()) {
                            return;
                        }
                        HistoryBox.this.setHistoryVisible(false);
                    }
                });
            }
        });
        ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(this.connectionServiceListener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return this.size;
    }

    public String getText(boolean upcasing) {
        String t = this.edLine.getText();
        if (!IAUtilities.hasContent((String)t) || t.matches("^ +$")) {
            return t;
        }
        if (this.items.contains(t)) {
            this.items.remove(t);
        } else if (this.items.size() >= this.itemsMaxCount) {
            this.items.removeLast();
        }
        this.items.addFirst(t);
        return upcasing ? t.toUpperCase() : t;
    }

    public void setLayoutData(Object ld) {
        super.setLayoutData(ld);
    }

    public void setToolTipText(String ttt) {
        this.edLine.setToolTipText(ttt);
    }

    public void addSelectionListener(SelectionListener sel) {
        this.edLine.addSelectionListener(sel);
    }

    public void addFocusListener(FocusListener fol) {
        this.edLine.addFocusListener(fol);
    }

    public Accessible getAccessible() {
        return this.edLine.getAccessible();
    }

    public void setText(String t) {
        this.assignText = true;
        this.edLine.setText(t);
    }

    public boolean isFocusControl() {
        return this.edLine.isFocusControl();
    }

    public void copyToClipboard() {
        String str = this.edLine.getSelectionText();
        if (!str.equals("")) {
            Clipboard clipboard = new Clipboard(this.parent.getDisplay());
            clipboard.setContents(new Object[]{this.edLine.getSelectionText()}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    public void dispose() {
        if (this.connectionServiceListener != null) {
            this.connectionServiceListener.makeStale();
        }
    }

    private void clear() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (HistoryBox.this.lbxHistory != null && !HistoryBox.this.lbxHistory.isDisposed()) {
                    HistoryBox.this.lbxHistory.removeAll();
                }
                HistoryBox.this.items.clear();
                if (HistoryBox.this.edLine != null && !HistoryBox.this.edLine.isDisposed()) {
                    HistoryBox.this.edLine.setText("");
                }
                HistoryBox.this.setHistoryVisible(false);
            }
        });
    }

    public void setModel(HistoryBoxModel model) {
        this.edLine.setText(model.getText());
        this.assignText = model.isAssignText();
        this.itemsMaxCount = model.getItemsMaxCount();
        this.items = model.getItems();
    }

    public HistoryBoxModel getModel() {
        HistoryBoxModel model = new HistoryBoxModel();
        model.setText(this.edLine.getText());
        model.setAssignText(this.assignText);
        model.setItemsMaxCount(this.itemsMaxCount);
        model.setItems(this.items);
        return model;
    }
}

