/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.composites;

import com.ibm.cics.ia.ui.CollectorOptionsEditor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.TreeItem;

public class GenericPropertyItem {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected String description;
    protected String key = "";
    protected String value = "";
    protected String oldValue = null;
    protected TreeItem treeItem;
    protected CollectorOptionsEditor atomEditor;
    protected static Font NORMAL_FONT;
    protected static Font BOLD_FONT;

    public GenericPropertyItem(TreeItem parent, CollectorOptionsEditor atomEditor, String key, String description) {
        this.atomEditor = atomEditor;
        this.treeItem = new TreeItem(parent, 0);
        this.treeItem.setData((Object)this);
        this.key = key;
        this.description = description;
        this.treeItem.setText(0, description);
        if (NORMAL_FONT == null) {
            NORMAL_FONT = parent.getFont();
        }
        if (BOLD_FONT == null) {
            FontData fontData = parent.getFont().getFontData()[0];
            BOLD_FONT = new Font((Device)parent.getDisplay(), fontData.getName(), fontData.getHeight(), fontData.getStyle() | 1);
        }
    }

    public void setValue(String value, boolean dirty) {
        this.value = value;
        this.treeItem.setText(1, value);
        this.oldValue = value;
    }

    public String getValue() {
        return this.value;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isModified() {
        return !this.value.equals(this.oldValue);
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return String.valueOf(this.description) + ": " + this.value;
    }

    public String getEmptyValue() {
        return "";
    }
}

