/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.composites;

import com.ibm.cics.ia.model.CincCollector;
import com.ibm.cics.ia.ui.CollectorOptionsEditor;
import com.ibm.cics.ia.ui.composites.ComboPropertyItem;
import com.ibm.cics.ia.ui.composites.PropertyValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;

public class ApplidComboPropertyItem
extends ComboPropertyItem
implements FocusListener,
SelectionListener {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String[] applids = null;
    private PropertyValidator validator;
    private boolean error = false;
    private HashMap<String, String> mroRegions;

    public ApplidComboPropertyItem(TreeItem parent, CollectorOptionsEditor atomEditor, String key, String description) {
        super(parent, atomEditor, key, description);
        this.combo = new CCombo((Composite)parent.getParent(), 8);
        this.combo.setBackground(parent.getParent().getBackground());
        this.combo.addSelectionListener((SelectionListener)this);
        this.combo.setToolTipText(description);
        this.combo.addFocusListener((FocusListener)this);
        this.mroRegions = null;
        this.populateCombo();
        this.editor = new TreeEditor(parent.getParent());
        this.editor.grabHorizontal = true;
        this.editor.setEditor((Control)this.combo, this.treeItem, 1);
        this.validator = new PropertyValidator(key);
    }

    @Override
    public void populateCombo() {
        CincCollector collector = (CincCollector)this.atomEditor.getCollector();
        this.mroRegions = collector.getMroRegions();
        ArrayList<String> applids = new ArrayList<String>();
        for (String str : this.mroRegions.keySet()) {
            applids.add(str);
        }
        Collections.sort(applids);
        this.combo.add("");
        this.combo.setData("", (Object)"");
        for (String str : applids) {
            this.combo.add(this.getComboText(str));
            this.combo.setData(this.getComboText(str), (Object)str);
        }
    }

    private String getComboText(String value) {
        if (this.mroRegions.containsKey(value)) {
            return String.valueOf(value) + " (" + this.mroRegions.get(value) + ")";
        }
        return "";
    }

    @Override
    public void setValue(String value, boolean dirty) {
        this.value = value;
        this.oldValue = value;
        this.combo.setText(this.getComboText(value));
        boolean exists = false;
        int i = 0;
        while (i < this.combo.getItemCount()) {
            if (this.combo.getItem(i).equals(this.getComboText(value))) {
                this.combo.select(i);
                exists = true;
                break;
            }
            ++i;
        }
        if (exists) {
            if (!dirty) {
                this.oldValue = value;
                this.treeItem.setFont(NORMAL_FONT);
                this.combo.setFont(NORMAL_FONT);
            } else {
                this.treeItem.setFont(BOLD_FONT);
                this.combo.setFont(BOLD_FONT);
            }
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (this.error) {
            this.combo.setText(this.getComboText(this.value));
            this.combo.setForeground(Display.getCurrent().getSystemColor(2));
            this.combo.setToolTipText("");
            this.error = false;
            this.atomEditor.removeError((Control)this.combo);
        }
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        String data;
        String item = this.combo.getItem(this.combo.getSelectionIndex());
        this.value = data = (String)this.combo.getData(item);
        if (!this.value.equals(this.oldValue)) {
            this.treeItem.setFont(BOLD_FONT);
            this.combo.setFont(BOLD_FONT);
            this.atomEditor.fireDirty();
        } else {
            this.treeItem.setFont(NORMAL_FONT);
            this.combo.setFont(NORMAL_FONT);
        }
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

