/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.composites;

import com.ibm.cics.dbfunc.model.Clause;
import com.ibm.cics.dbfunc.model.ClauseGroup;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.ConstraintElement;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.composites.QueryEditableTableComposite;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ApplicationQueryEditableTableComposite
extends QueryEditableTableComposite {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    @Override
    protected void recalculateFromEditableTable(Table aTable, boolean is) {
        Clause newClause;
        String fieldName = "";
        ColumnReference column = null;
        if (this.constraint instanceof Clause) {
            column = (ColumnReference)((Clause)this.constraint).getColumns().get(0);
        } else {
            ClauseGroup clauses = (ClauseGroup)this.constraint;
            Clause clause = (Clause)clauses.getClauses().get(0);
            column = (ColumnReference)clause.getColumns().get(0);
        }
        ArrayList<String> values = new ArrayList<String>();
        TableItem[] tablesItems = aTable.getItems();
        int i = 0;
        while (i < tablesItems.length) {
            String value = (String)tablesItems[i].getData();
            if (IAUtilities.hasContent((String)value)) {
                values.add(value);
            }
            ++i;
        }
        if (values.size() > 1) {
            Selection selection = PresentationFactory.getInstance().createSelectAllForTable("", "");
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                Comparator comparator = Comparator.LI;
                Object next = iter.next();
                if (!IAUtilities.containsWildcard((String)((String)next))) {
                    comparator = Comparator.EQ;
                }
                Clause nextClause = PresentationFactory.getInstance().createSimpleCondition(column, comparator, new Object[]{next}, !is);
                selection.appendCondition((ConstraintElement)nextClause, QueryElement.Predicate.OR);
            }
            this.constraint = selection.getCondition();
        } else if (values.size() == 1) {
            if (IAUtilities.hasContent((String)((String)values.get(0)))) {
                Comparator comparator = Comparator.LI;
                if (!IAUtilities.containsWildcard((String)((String)values.get(0)))) {
                    comparator = Comparator.EQ;
                }
                newClause = PresentationFactory.getInstance().createSimpleCondition(column, comparator, values.toArray(), !is);
                this.constraint = newClause;
            }
        } else if (values.size() == 0) {
            Object[] newValues = new Object[]{""};
            newClause = PresentationFactory.getInstance().createSimpleCondition(column, Comparator.EQ, newValues, !is);
            this.constraint = newClause;
        }
        this.notifyListeners();
    }
}

