/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.composites;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.commands.GetApplicationInfoCommand;
import com.ibm.cics.ia.model.AtomDefinitions;
import com.ibm.cics.ia.query.QueryCompatibilityHelper;
import com.ibm.cics.ia.query.SQLDefinitions;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.ApplicationSelectionDialog;
import com.ibm.cics.ia.ui.CollectorOptionsEditor;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.composites.ApplicationModePropertyItem;
import com.ibm.cics.ia.ui.composites.GenericPropertyItem;
import com.ibm.cics.ia.ui.composites.ISwitchablePropertyItem;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

public class ApplicationInfoPropertyItem
extends GenericPropertyItem
implements ISwitchablePropertyItem {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static Logger logger = Logger.getLogger(ApplicationInfoPropertyItem.class.getPackage().getName());
    private TextWithButton composite;
    private String[] applIds;
    private List<GetApplicationInfoCommand.ApplicationInfo> applicationInfos;
    private GetApplicationInfoCommand.ApplicationInfo oldInfo = new GetApplicationInfoCommand.ApplicationInfo();
    private GetApplicationInfoCommand.ApplicationInfo currentInfo = new GetApplicationInfoCommand.ApplicationInfo();

    public ApplicationInfoPropertyItem(TreeItem parent, final CollectorOptionsEditor atomEditor, String key, String description) {
        super(parent, atomEditor, key, description);
        Debug.enter((Logger)logger, (String)ApplicationInfoPropertyItem.class.getName(), (String)"ApplicationInfoPropertyItem", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.composite = new TextWithButton((Composite)parent.getParent(), 0);
        this.composite.addButtonListener(new Listener(){

            public void handleEvent(Event event) {
                Debug.enter((Logger)logger, (String)"ApplicationInfoPropertyItem.ApplicationInfoPropertyItem().addButtonListener()", (String)"handleEvent", (Object)("Thread ID: " + Thread.currentThread().getId()));
                String errorMessage = ApplicationInfoPropertyItem.this.retrieveApplicationInfos();
                if (errorMessage == null) {
                    ApplicationSelectionDialog dialog = new ApplicationSelectionDialog(Display.getCurrent().getActiveShell(), ApplicationInfoPropertyItem.this.applicationInfos);
                    if (dialog.open() == 0) {
                        ApplicationInfoPropertyItem.this.currentInfo = dialog.getSelected();
                        if (ApplicationInfoPropertyItem.this.isModified()) {
                            ApplicationInfoPropertyItem.this.refreshValue(true);
                            atomEditor.fireDirty();
                        }
                        atomEditor.removeError((Control)ApplicationInfoPropertyItem.this.composite);
                    }
                } else {
                    MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 40);
                    messageBox.setText(com.ibm.cics.ia.ui.composites.Messages.getString("CollectorOptionsEditor.ApplicationSelection.error.title"));
                    messageBox.setMessage(errorMessage);
                    messageBox.open();
                }
                Debug.exit((Logger)logger, (String)"ApplicationInfoPropertyItem.ApplicationInfoPropertyItem().addButtonListener()", (String)"handleEvent");
            }
        });
        TreeEditor editor = new TreeEditor(parent.getParent());
        editor.grabHorizontal = true;
        editor.setEditor((Control)this.composite, this.treeItem, 1);
        Debug.exit((Logger)logger, (String)ApplicationInfoPropertyItem.class.getName(), (String)"ApplicationInfoPropertyItem");
    }

    @Override
    public void setEnabled(boolean enabled) {
        Debug.enter((Logger)logger, (String)ApplicationInfoPropertyItem.class.getName(), (String)"setEnabled", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (enabled && this.currentInfo.getName() == null) {
            String errorMessage = MessageFormat.format(Messages.getString("CollectorOptionsEditor.invalid.text.empty"), Messages.getString("CollectorOptionsEditor.Property.appl_name"));
            this.composite.setToolTipText(errorMessage);
            this.atomEditor.addError((Control)this.composite, errorMessage);
        } else {
            this.atomEditor.removeError((Control)this.composite);
        }
        Color color = enabled ? Display.getCurrent().getSystemColor(2) : Display.getCurrent().getSystemColor(16);
        this.treeItem.setForeground(color);
        this.composite.setForeground(color);
        this.composite.setButtonEnabled(enabled);
        Debug.exit((Logger)logger, (String)ApplicationInfoPropertyItem.class.getName(), (String)"setEnabled");
    }

    @Override
    public boolean isEnabled() {
        return this.composite.isButtonEnabled();
    }

    public void refreshValue(boolean dirty) {
        Debug.enter((Logger)logger, (String)ApplicationInfoPropertyItem.class.getName(), (String)"refreshValue", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.currentInfo.getName() == null) {
            this.composite.setText(this.getEmptyValue());
        } else {
            this.composite.setText(this.currentInfo.toString());
            if (dirty) {
                this.treeItem.setFont(BOLD_FONT);
                this.composite.setTextFont(BOLD_FONT);
            } else {
                this.treeItem.setFont(NORMAL_FONT);
                this.composite.setTextFont(NORMAL_FONT);
                this.oldInfo = new GetApplicationInfoCommand.ApplicationInfo(this.currentInfo);
            }
        }
        ApplicationModePropertyItem item = (ApplicationModePropertyItem)this.atomEditor.getPropertyField("appl_mode", false);
        this.setEnabled(AtomDefinitions.APPLICATION_MODE_FIELDS[1].equals(item.getValue()));
        Debug.exit((Logger)logger, (String)ApplicationInfoPropertyItem.class.getName(), (String)"refreshValue");
    }

    private String getCompatibilityInfo() {
        Debug.enter((Logger)logger, (String)ApplicationInfoPropertyItem.class.getName(), (String)"getCompatibilityInfo", (Object)("Thread ID: " + Thread.currentThread().getId()));
        List<String> requiredColumns = Arrays.asList(SQLDefinitions.ia51SpecificAttributes.getAttributes());
        Map unsupportedAttributes = SQLDefinitions.CICS_ATTRIBUTES.checkCompatibility(requiredColumns);
        StringBuilder reason = new StringBuilder();
        QueryCompatibilityHelper.getCompatibilityInfo((String)"CICS.Column.", (StringBuilder)reason, (Map)unsupportedAttributes);
        Debug.exit((Logger)logger, (String)ApplicationInfoPropertyItem.class.getName(), (String)"getCompatibilityInfo");
        return reason.toString();
    }

    private String retrieveApplicationInfos() {
        Debug.enter((Logger)logger, (String)ApplicationInfoPropertyItem.class.getName(), (String)"retrieveApplicationInfos", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Activator.getDefault().ensureConnected();
        String compatibilityError = this.getCompatibilityInfo();
        if (compatibilityError.isEmpty()) {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
            try {
                dialog.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        monitor.beginTask(com.ibm.cics.ia.ui.composites.Messages.getString("CollectorOptionsEditor.ApplicationSelection.progress"), -1);
                        if (ApplicationInfoPropertyItem.this.applIds == null) {
                            ApplicationInfoPropertyItem.this.applIds = new String[AtomDefinitions.CMDFLOW_APPLIDS.length];
                            int i = 0;
                            while (i < AtomDefinitions.CMDFLOW_APPLIDS.length) {
                                ((ApplicationInfoPropertyItem)ApplicationInfoPropertyItem.this).applIds[i] = ApplicationInfoPropertyItem.this.atomEditor.getPropertyField(AtomDefinitions.CMDFLOW_APPLIDS[i], false).getValue();
                                ++i;
                            }
                        }
                        GetApplicationInfoCommand cmd = new GetApplicationInfoCommand(ApplicationInfoPropertyItem.this.applIds);
                        cmd.setAsync(false);
                        cmd.start();
                        ApplicationInfoPropertyItem.this.applicationInfos = cmd.getApplicationInfos();
                        monitor.done();
                    }
                });
            }
            catch (Exception e) {
                Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"retrieveApplicationInfos", (Throwable)e);
            }
            Debug.exit((Logger)logger, (String)ApplicationInfoPropertyItem.class.getName(), (String)"retrieveApplicationInfos");
            return this.applicationInfos.isEmpty() ? com.ibm.cics.ia.ui.composites.Messages.getString("CollectorOptionsEditor.ApplicationSelection.empty") : null;
        }
        Debug.exit((Logger)logger, (String)ApplicationInfoPropertyItem.class.getName(), (String)"retrieveApplicationInfos");
        return compatibilityError;
    }

    public GetApplicationInfoCommand.ApplicationInfo getCurrentInfo() {
        return this.currentInfo;
    }

    public GetApplicationInfoCommand.ApplicationInfo getOldInfo() {
        return this.oldInfo;
    }

    @Override
    public boolean isModified() {
        return !this.oldInfo.equals((Object)this.currentInfo);
    }

    public void setApplIds(String ... applIds) {
        this.applIds = applIds;
    }

    static class TextWithButton
    extends Composite {
        private Text text;
        private Button button;

        public TextWithButton(Composite parent, int style) {
            super(parent, style);
            GridLayout layout = new GridLayout(2, false);
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.setLayout((Layout)layout);
            this.text = new Text((Composite)this, 0);
            GridData gridData = new GridData(4, 4, true, true);
            this.text.setLayoutData((Object)gridData);
            this.text.setEditable(false);
            this.text.setBackground(Display.getCurrent().getSystemColor(1));
            this.button = new Button((Composite)this, 0);
            gridData = new GridData();
            gridData.grabExcessVerticalSpace = true;
            this.button.setLayoutData((Object)gridData);
            this.button.setText("...");
        }

        public void setButtonEnabled(boolean enabled) {
            this.button.setEnabled(enabled);
        }

        public void setText(String t) {
            this.text.setText(t);
        }

        public boolean isButtonEnabled() {
            return this.button.isEnabled();
        }

        public void addButtonListener(Listener listener) {
            this.button.addListener(13, listener);
        }

        public void setTextFont(Font font) {
            this.text.setFont(font);
        }

        public void setForeground(Color color) {
            this.text.setForeground(color);
        }
    }
}

