/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.composites;

import com.ibm.cics.ia.model.AtomDefinitions;
import com.ibm.cics.ia.ui.CollectorOptionsEditor;
import com.ibm.cics.ia.ui.composites.ApplicationModePropertyItem;
import com.ibm.cics.ia.ui.composites.ComboPropertyItem;
import com.ibm.cics.ia.ui.composites.Messages;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;

public class ApplicationContextValuesPropertyItem
extends ComboPropertyItem {
    private boolean comboEnabled;

    public ApplicationContextValuesPropertyItem(TreeItem parent, CollectorOptionsEditor atomEditor, String key, String description) {
        super(parent, atomEditor, key, description);
        this.combo = new CCombo((Composite)parent.getParent(), 8);
        this.combo.setToolTipText(description);
        this.combo.setBackground(parent.getParent().getBackground());
        this.combo.addSelectionListener((SelectionListener)this);
        this.populateCombo();
        this.editor = new TreeEditor(parent.getParent());
        this.editor.grabHorizontal = true;
        this.editor.setEditor((Control)this.combo, this.treeItem, 1);
    }

    @Override
    public void populateCombo() {
        int i = 0;
        while (i < AtomDefinitions.APPLICATION_CONTEXT_VALUES.length) {
            this.combo.add(Messages.getString("CollectorOptionsEditor.ApplicationContextValues." + AtomDefinitions.APPLICATION_CONTEXT_VALUES[i]));
            ++i;
        }
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        this.value = AtomDefinitions.APPLICATION_CONTEXT_VALUES[this.combo.getSelectionIndex()];
        if (!this.value.equals(this.oldValue)) {
            this.treeItem.setFont(BOLD_FONT);
            this.combo.setFont(BOLD_FONT);
            this.atomEditor.fireDirty();
        } else {
            this.treeItem.setFont(NORMAL_FONT);
            this.combo.setFont(NORMAL_FONT);
        }
    }

    @Override
    public void setValue(String value, boolean dirty) {
        if (value.isEmpty()) {
            value = AtomDefinitions.APPLICATION_CONTEXT_VALUES[0];
        }
        this.value = value;
        int index = -1;
        this.combo.setText(Messages.getString("CollectorOptionsEditor.ApplicationContextValues." + value));
        int i = 0;
        while (i < this.combo.getItemCount()) {
            if (this.combo.getItem(i).equals(value)) {
                this.combo.select(i);
                break;
            }
            ++i;
        }
        if (!dirty) {
            this.oldValue = value;
            this.treeItem.setFont(NORMAL_FONT);
            this.combo.setFont(NORMAL_FONT);
        } else {
            this.treeItem.setFont(BOLD_FONT);
            this.combo.setFont(BOLD_FONT);
        }
        ApplicationModePropertyItem appModeItem = (ApplicationModePropertyItem)this.atomEditor.getPropertyField("appl_mode", false);
        if (appModeItem != null) {
            this.setEnabled(!AtomDefinitions.APPLICATION_MODE_FIELDS[2].equals(appModeItem.getValue()));
        }
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public boolean isEnabled() {
        return this.comboEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.combo.setEnabled(enabled);
        this.comboEnabled = enabled;
    }
}

