/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.actions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.eclipse.common.ui.JobWithCancelingSupport;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.ui.actions.Messages;
import com.ibm.cics.ia.ui.actions.UsesAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;

public class UsesObjectActionDelegate
implements IObjectActionDelegate,
IMenuCreator,
IWorkbenchWindowPulldownDelegate {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(UsesObjectActionDelegate.class.getPackage().getName());
    private Action delegateAction;
    Resource resource;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Debug.enter((Logger)logger, (String)UsesObjectActionDelegate.class.getName(), (String)"selectionChanged", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (((IStructuredSelection)selection).size() != 1) {
            action.setEnabled(false);
        } else if (action instanceof Action) {
            Object firstElement;
            if (this.delegateAction != action) {
                this.delegateAction = (Action)action;
                this.delegateAction.setMenuCreator((IMenuCreator)this);
            }
            if ((firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof Resource) {
                this.resource = (Resource)firstElement;
            } else {
                action.setEnabled(false);
            }
        } else {
            action.setEnabled(false);
        }
        Debug.exit((Logger)logger, (String)UsesObjectActionDelegate.class.getName(), (String)"selectionChanged");
    }

    public void dispose() {
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public Menu getMenu(Menu parent) {
        Debug.enter((Logger)logger, (String)UsesObjectActionDelegate.class.getName(), (String)"getMenu", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Menu menu = new Menu(parent);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu m = (Menu)e.widget;
                MenuItem[] items = m.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                UsesObjectActionDelegate.this.fillMenu(m);
            }
        });
        Debug.exit((Logger)logger, (String)UsesObjectActionDelegate.class.getName(), (String)"getMenu");
        return menu;
    }

    private void fillMenu(final Menu m) {
        Debug.enter((Logger)logger, (String)UsesObjectActionDelegate.class.getName(), (String)"fillMenu", (Object)("Thread ID: " + Thread.currentThread().getId()));
        UsesAction usedByAction = new UsesAction(this.resource, null);
        usedByAction.setText(Messages.getString("AllRegions.txt"));
        ActionContributionItem item = new ActionContributionItem((IAction)usedByAction);
        item.fill(m, -1);
        String fetchRegionsMsg = Messages.getString("FetchRegionsFor.msg");
        final String fetchRegionsForResourceMsg = MessageFormat.format(fetchRegionsMsg, this.resource.getName());
        final JobWithCancelingSupport job = new JobWithCancelingSupport(fetchRegionsForResourceMsg){

            protected IStatus runSub(IProgressMonitor monitor) {
                Debug.enter((Logger)logger, (String)"UsesObjectActionDelegate.fillMenu().job", (String)"runSub", (Object)("Thread ID: " + Thread.currentThread().getId()));
                monitor.beginTask(fetchRegionsForResourceMsg, -1);
                List regions = UsesObjectActionDelegate.this.resource.getRegions();
                Iterator iter = regions.iterator();
                final ArrayList<ActionContributionItem> items = new ArrayList<ActionContributionItem>();
                while (iter.hasNext()) {
                    Region region = (Region)iter.next();
                    UsesAction usedByAction = new UsesAction(UsesObjectActionDelegate.this.resource, region);
                    usedByAction.setText(region.getName());
                    items.add(new ActionContributionItem((IAction)usedByAction));
                }
                m.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Iterator itemsIter = items.iterator();
                        while (itemsIter.hasNext()) {
                            if (m.isDisposed()) {
                                return;
                            }
                            ActionContributionItem item = (ActionContributionItem)itemsIter.next();
                            item.fill(m, -1);
                        }
                    }
                });
                Debug.exit((Logger)logger, (String)"UsesObjectActionDelegate.fillMenu().job", (String)"runSub");
                return Status.OK_STATUS;
            }

            protected void cancelingSub() {
                IAPlugin.getDefault().taskEnded();
            }
        };
        job.schedule();
        m.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                job.cancel();
            }
        });
        Debug.exit((Logger)logger, (String)UsesObjectActionDelegate.class.getName(), (String)"fillMenu");
    }

    public void init(IWorkbenchWindow window) {
    }
}

