/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.actions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.ICredentialsManager;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.ia.commands.QueryCommand;
import com.ibm.cics.ia.controller.DisplayableData;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.MoreUsersDialog;
import com.ibm.cics.ia.ui.actions.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class TransactionRunsForUserId
extends Action
implements IWorkbenchWindowActionDelegate {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(TransactionRunsForUserId.class.getPackage().getName());
    private Transaction transaction;
    private IAction action;

    public TransactionRunsForUserId() {
    }

    public TransactionRunsForUserId(Transaction transaction) {
        this.transaction = transaction;
    }

    public TransactionRunsForUserId(Transaction iaResource, Region iaRegion) {
        this.transaction = iaResource;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run() {
        IConnectable iConnectable;
        Debug.enter((Logger)logger, (String)TransactionRunsForUserId.class.getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        List<String> userIds = null;
        String actionId = "";
        if (this.action != null) {
            actionId = this.action.getId();
        }
        if (actionId.equals("com.ibm.cics.ia.ui.actions.cmdflowruns.selectuser")) {
            MoreUsersDialog dialog = new MoreUsersDialog(Display.getCurrent().getActiveShell(), this.transaction, true);
            if (dialog.open() != 0) {
                Debug.exit((Logger)logger, (String)TransactionRunsForUserId.class.getName(), (String)"run");
                return;
            }
            userIds = dialog.getSelection();
        } else if (actionId.equals("com.ibm.cics.ia.ui.actions.cmdflowruns.currentuser") && (iConnectable = ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.ia.connection.db2")).getConnection() != null) {
            ICredentialsManager mgr = ConnectionsPlugin.getDefault().getConnectionService().getConnectionManager().getCredentialsManager();
            CredentialsConfiguration credentials = mgr.findCredentialsConfigurationByID(iConnectable.getConnection().getConfiguration().getCredentialsID());
            userIds = new ArrayList<String>();
            userIds.add(credentials.getUserID());
        }
        QueryCommand tasksCommand = this.transaction.createGetCommandFlowRunsForSpecificUserCommand(userIds);
        tasksCommand.setSaveable(false);
        DisplayableData displayableData = (DisplayableData)tasksCommand.getAdapter(DisplayableData.class);
        String description = "";
        description = userIds != null ? MessageFormat.format(Messages.getString("TransactionRunsSpecificUsersAction.description"), userIds + " " + this.transaction.toString()) : MessageFormat.format(Messages.getString("TransactionRunsAction.description"), this.transaction.toString());
        displayableData.setDescription(description);
        displayableData.setImage(ImageFactory.getSearchImage());
        Activator.executeSearch((Command)tasksCommand);
        Debug.exit((Logger)logger, (String)TransactionRunsForUserId.class.getName(), (String)"run");
    }

    public void run(IAction action) {
        Debug.enter((Logger)logger, (String)TransactionRunsForUserId.class.getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.action = action;
        this.run();
        Debug.exit((Logger)logger, (String)TransactionRunsForUserId.class.getName(), (String)"run");
    }

    public void selectionChanged(IAction action, ISelection selection) {
        StructuredSelection structuredSelection;
        Object firstElement;
        Debug.enter((Logger)logger, (String)TransactionRunsForUserId.class.getName(), (String)"selectionChanged", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (selection instanceof StructuredSelection && (firstElement = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof Transaction) {
            this.transaction = (Transaction)firstElement;
        }
        Debug.exit((Logger)logger, (String)TransactionRunsForUserId.class.getName(), (String)"selectionChanged");
    }
}

