/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.actions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.eclipse.common.ui.JobWithCancelingSupport;
import com.ibm.cics.ia.commands.FindProgramsForRegionCommand;
import com.ibm.cics.ia.commands.FindProgramsForRegionWithPresentationLogicCommand;
import com.ibm.cics.ia.commands.QueryCommand;
import com.ibm.cics.ia.commands.QueryDifferenceCommand;
import com.ibm.cics.ia.controller.DisplayableData;
import com.ibm.cics.ia.query.Messages;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.UIUtilities;
import com.ibm.cics.ia.ui.actions.RegionAction;
import com.ibm.cics.ia.ui.actions.ShowMapsForRegionAction;
import java.text.MessageFormat;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;

public class ShowProgramsForRegionAction
extends RegionAction {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ShowMapsForRegionAction.class.getPackage().getName());
    private Job job;
    private QueryCommand findProgramsCommandQueryCommand;
    private QueryCommand findProgramsForRegionWithPresentationLogicQueryCommand;

    @Override
    public void run(IAction action) {
        Debug.enter((Logger)logger, (String)ShowMapsForRegionAction.class.getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.executeRegionQuery("PROGRAM");
        Debug.exit((Logger)logger, (String)ShowMapsForRegionAction.class.getName(), (String)"run");
    }

    @Override
    public void executeRegionQuery(String resourceType) {
        Debug.enter((Logger)logger, (String)RegionAction.class.getName(), (String)"executeRegionQuery", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String resourcesForEditorLabelString = Messages.getString((String)Messages.getString((String)"RegionProgramQuery.1"));
        final String resourceForEditorLabel = MessageFormat.format(resourcesForEditorLabelString, this.getRegion().getName());
        String resourcesForTaskString = Messages.getString((String)Messages.getString((String)"RegionProgramQuery.2"));
        final String resourceForTaskLabel = MessageFormat.format(resourcesForTaskString, this.getRegion().getName());
        FindProgramsForRegionCommand findProgramsCommand = new FindProgramsForRegionCommand(this.getRegion(), resourceType);
        Presentation findProgramsPresentation = PresentationFactory.getInstance().createPresentation(resourceForEditorLabel, "", "", (Selection)findProgramsCommand.getSelectionObject());
        this.findProgramsCommandQueryCommand = new QueryCommand(findProgramsPresentation);
        this.findProgramsCommandQueryCommand.setDescription(resourceForEditorLabel);
        DisplayableData findProgramsCommandQueryCommandData = (DisplayableData)this.findProgramsCommandQueryCommand.getAdapter(DisplayableData.class);
        findProgramsCommandQueryCommandData.setDescription(resourceForEditorLabel);
        this.findProgramsCommandQueryCommand.setSaveable(false);
        FindProgramsForRegionWithPresentationLogicCommand findProgramsForRegionWithPresentationLogicCommand = new FindProgramsForRegionWithPresentationLogicCommand(this.getRegion(), resourceType);
        Presentation findProgramsWithPresentationLogicPresentation = PresentationFactory.getInstance().createPresentation(resourceForEditorLabel, "", "", (Selection)findProgramsForRegionWithPresentationLogicCommand.getSelectionObject());
        this.findProgramsForRegionWithPresentationLogicQueryCommand = new QueryCommand(findProgramsWithPresentationLogicPresentation);
        this.findProgramsForRegionWithPresentationLogicQueryCommand.setDescription(resourceForEditorLabel);
        DisplayableData FindProgramsWithPresentaionLogicData = (DisplayableData)this.findProgramsForRegionWithPresentationLogicQueryCommand.getAdapter(DisplayableData.class);
        FindProgramsWithPresentaionLogicData.setDescription(resourceForEditorLabel);
        this.findProgramsForRegionWithPresentationLogicQueryCommand.setSaveable(false);
        this.job = new JobWithCancelingSupport(resourceForTaskLabel){

            protected IStatus runSub(IProgressMonitor monitor) {
                Debug.enter((Logger)logger, (String)"QueryResultsView.executeSearch.queryJob", (String)"run", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId()});
                monitor.beginTask(resourceForTaskLabel, -1);
                boolean findProgramsCommandQueryCommandResult = ShowProgramsForRegionAction.this.runCommand(ShowProgramsForRegionAction.this.findProgramsCommandQueryCommand);
                boolean findProgramsForRegionWithPresentationLogicQueryCommandResult = ShowProgramsForRegionAction.this.runCommand(ShowProgramsForRegionAction.this.findProgramsForRegionWithPresentationLogicQueryCommand);
                if (findProgramsCommandQueryCommandResult && findProgramsForRegionWithPresentationLogicQueryCommandResult) {
                    ShowProgramsForRegionAction.this.executeQueryDifference(ShowProgramsForRegionAction.this.findProgramsCommandQueryCommand, ShowProgramsForRegionAction.this.findProgramsForRegionWithPresentationLogicQueryCommand, resourceForEditorLabel);
                }
                monitor.done();
                IAPlugin.getDefault().taskEnded();
                Debug.exit((Logger)logger, (String)"QueryResultsView.executeSearch.queryJob", (String)"run");
                return Status.OK_STATUS;
            }

            protected void cancelingSub() {
                super.canceling();
                IAPlugin.getDefault().taskEnded();
            }
        };
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                UIUtilities.scheduleWorkbenchPartJob((IWorkbenchPart)Activator.getEmptyQueryResultView(), ShowProgramsForRegionAction.this.job);
            }
        });
        Debug.exit((Logger)logger, (String)ShowProgramsForRegionAction.class.getName(), (String)"executeRegionQuery");
    }

    private void executeQueryDifference(QueryCommand inCommand, QueryCommand notInCommand, String description) {
        Debug.enter((Logger)logger, (String)ShowProgramsForRegionAction.class.getName(), (String)"executeQueryDifference", (Object)("Thread ID: " + Thread.currentThread().getId()));
        QueryDifferenceCommand queryDiffCommand = new QueryDifferenceCommand();
        queryDiffCommand.getInCommands().add(inCommand);
        queryDiffCommand.getNotInCommands().add(notInCommand);
        DisplayableData displayableData = (DisplayableData)queryDiffCommand.getAdapter(DisplayableData.class);
        displayableData.setImage(ImageFactory.getResourceImage());
        displayableData.setDescription(description);
        queryDiffCommand.setDescription(description);
        Activator.executeSyncSearch((Command)queryDiffCommand);
        Debug.exit((Logger)logger, (String)ShowProgramsForRegionAction.class.getName(), (String)"executeQueryDifference");
    }

    private boolean runCommand(QueryCommand command) {
        Debug.enter((Logger)logger, (String)ShowProgramsForRegionAction.class.getName(), (String)"runCommand", (Object)("Thread ID: " + Thread.currentThread().getId()));
        command.setAsync(false);
        command.start();
        while (command.status() == 3) {
            command.start();
        }
        if (command.status() == 2) {
            Debug.exit((Logger)logger, (String)ShowProgramsForRegionAction.class.getName(), (String)"executeAndSaveResults", (Object)"return false");
            return false;
        }
        Debug.exit((Logger)logger, (String)ShowProgramsForRegionAction.class.getName(), (String)"runCommand", (Object)"return true");
        return true;
    }
}

