/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.actions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.AffinityType;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.AffinityView;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class ShowAffinityAction
extends Action
implements IWorkbenchWindowActionDelegate {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ShowAffinityAction.class.getPackage().getName());
    private Resource resource = null;
    private String affinityType = "";

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void setResource(Resource aResource) {
        this.resource = aResource;
    }

    public void setAffinityType(String anAffinityType) {
        this.affinityType = anAffinityType;
    }

    public void run() {
        IEditorPart editor = Activator.openEditor(AffinityView.DEFAULT_EDITOR_INPUT, "com.ibm.cics.ia.ui.AffinityView", true);
        if (editor != null) {
            ((AffinityView)editor).setInput(null, this.resource, this.affinityType);
        }
    }

    public void run(IAction action) {
        IEditorPart editor;
        Debug.enter((Logger)logger, (String)ShowAffinityAction.class.getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String actionId = action.getId();
        String affinityType = null;
        AffinityType[] affinityTypeArray = AffinityType.values();
        int n = affinityTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AffinityType type = affinityTypeArray[n2];
            if (actionId.endsWith(type.toString())) {
                affinityType = type.getName();
            }
            ++n2;
        }
        if (this.resource instanceof Region) {
            editor = Activator.openEditor(AffinityView.DEFAULT_EDITOR_INPUT, "com.ibm.cics.ia.ui.AffinityView", true);
            if (editor != null) {
                ((AffinityView)editor).setInput((Region)this.resource, null, affinityType);
            }
        } else {
            editor = Activator.openEditor(AffinityView.DEFAULT_EDITOR_INPUT, "com.ibm.cics.ia.ui.AffinityView", true);
            if (editor != null) {
                ((AffinityView)editor).setInput(null, this.resource, affinityType);
            }
        }
        Debug.exit((Logger)logger, (String)ShowAffinityAction.class.getName(), (String)"run");
    }

    public void selectionChanged(IAction action, ISelection selection) {
        StructuredSelection structuredSelection;
        Object firstElement;
        Debug.enter((Logger)logger, (String)ShowAffinityAction.class.getName(), (String)"selectionChanged", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (selection instanceof StructuredSelection && (firstElement = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof Resource) {
            this.resource = (Resource)firstElement;
        }
        Debug.exit((Logger)logger, (String)ShowAffinityAction.class.getName(), (String)"selectionChanged");
    }
}

