/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.actions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.ia.commands.QueryCommand;
import com.ibm.cics.ia.commands.ShowScannerCommandsCommand;
import com.ibm.cics.ia.controller.DisplayableData;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.actions.Messages;
import java.text.MessageFormat;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class ScannerCommandsAction
extends Action
implements IWorkbenchWindowActionDelegate {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ScannerCommandsAction.class.getPackage().getName());
    private Program program;
    private Resource dsn;
    public static final String SHOW_ALL_COMMANDS = "SHOW_ALL_COMMANDS";
    public static final String SHOW_COMMANDS_AFFINITIES = "SHOW_COMMANDS_AFFINITIES";
    public static final String SHOW_COMMANDS_DEPENDENCIES = "SHOW_COMMANDS_DEPENDENCIES";

    public void run(IAction action) {
        Debug.enter((Logger)logger, (String)ScannerCommandsAction.class.getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String description = MessageFormat.format(Messages.getString("ShowScannerAllCommandsCommand.text"), this.program.getName());
        boolean affs = false;
        boolean deps = false;
        if (action.getId().equals(SHOW_COMMANDS_AFFINITIES)) {
            affs = true;
            description = MessageFormat.format(Messages.getString("ShowScannerCommandsAffinitiesCommand.text"), this.program.getName());
        }
        if (action.getId().equals(SHOW_COMMANDS_DEPENDENCIES)) {
            deps = true;
            description = MessageFormat.format(Messages.getString("ShowScannerCommandsDependenciesCommand.text"), this.program.getName());
        }
        ShowScannerCommandsCommand command = new ShowScannerCommandsCommand(this.program, this.dsn, affs, deps);
        Presentation presentation = PresentationFactory.getInstance().createPresentation(description, "", "", (Selection)command.getSelectionObject());
        QueryCommand queryCommand = new QueryCommand(presentation);
        queryCommand.setDescription(description);
        DisplayableData data = (DisplayableData)queryCommand.getAdapter(DisplayableData.class);
        data.setDescription(description);
        queryCommand.setSaveable(false);
        Activator.executeSearch((Command)queryCommand);
        Debug.exit((Logger)logger, (String)ScannerCommandsAction.class.getName(), (String)"run");
    }

    public void run() {
        this.run((IAction)this);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        StructuredSelection structuredSelection;
        Object firstElement;
        Debug.enter((Logger)logger, (String)ScannerCommandsAction.class.getName(), (String)"selectionChanged", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (selection instanceof StructuredSelection && (firstElement = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof Program) {
            this.program = (Program)firstElement;
        }
        Debug.exit((Logger)logger, (String)ScannerCommandsAction.class.getName(), (String)"selectionChanged");
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void setDsn(Resource aDsn) {
        this.dsn = aDsn;
    }

    public void setProgram(Program aProgram) {
        this.program = aProgram;
    }
}

