/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.actions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.AtomContentElement;
import com.ibm.cics.ia.model.CintCollector;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.actions.CollectorAction;
import java.text.MessageFormat;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;

public class SaveCintOptionsAction {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(SaveCintOptionsAction.class.getPackage().getName());
    private CintCollector collector;
    private AtomContentElement element;

    public SaveCintOptionsAction(CintCollector collector) {
        this.collector = collector;
    }

    public void run(AtomContentElement element) {
        Debug.enter((Logger)logger, (String)SaveCintOptionsAction.class.getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.element = element;
        String state = this.collector.getState();
        if ("RUNNING".equals(state)) {
            MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 200);
            messageBox.setText(Messages.getString("SaveCintOptionsDialog.title.text"));
            messageBox.setMessage(MessageFormat.format(Messages.getString("SaveCintOptionsDialog.message.text"), this.collector.getRegion().getName()));
            int result = messageBox.open();
            if (result == 128) {
                return;
            }
            if (result == 64) {
                CollectorAction stopAction = new CollectorAction();
                stopAction.setId(CollectorAction.CINT_STOP_ACTION);
                stopAction.setCintCollector(this.collector);
                stopAction.run();
            }
        }
        CollectorAction saveAction = new CollectorAction();
        saveAction.setId(CollectorAction.SAVE_REGION_OPTIONS_ACTION);
        saveAction.setCintCollector(this.collector);
        saveAction.setAtomContent(element);
        saveAction.run();
        Debug.exit((Logger)logger, (String)SaveCintOptionsAction.class.getName(), (String)"enclosing_method");
    }
}

