/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.actions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.ia.commands.FindResourcesForRegionCommand;
import com.ibm.cics.ia.commands.QueryCommand;
import com.ibm.cics.ia.controller.DisplayableData;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.query.Messages;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.ResourceTypeRenderer;
import java.text.MessageFormat;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class RegionAction
extends Action
implements IWorkbenchWindowActionDelegate {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(RegionAction.class.getPackage().getName());
    private Region region;

    public Region getRegion() {
        return this.region;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object firstElement;
        Debug.enter((Logger)logger, (String)RegionAction.class.getName(), (String)"selectionChanged", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (selection instanceof StructuredSelection && (firstElement = ((StructuredSelection)selection).getFirstElement()) instanceof Region) {
            this.region = (Region)firstElement;
        }
        Debug.exit((Logger)logger, (String)RegionAction.class.getName(), (String)"selectionChanged");
    }

    public void run(IAction action) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void executeRegionQuery(String resourceType) {
        Debug.enter((Logger)logger, (String)RegionAction.class.getName(), (String)"executeRegionQuery", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String resourceDescription = ResourceTypeRenderer.asText(resourceType);
        String resourcesForQueryString = Messages.getString((String)Messages.getString((String)"RegionQuery.1"));
        String resourcesForQueryLabel = MessageFormat.format(resourcesForQueryString, resourceDescription, this.region.getName());
        FindResourcesForRegionCommand findCommand = new FindResourcesForRegionCommand(this.region, resourceType);
        Presentation presentation = PresentationFactory.getInstance().createPresentation(resourcesForQueryLabel, "", "", (Selection)findCommand.getSelectionObject());
        QueryCommand command = new QueryCommand(presentation);
        command.setDescription(resourcesForQueryLabel);
        DisplayableData data = (DisplayableData)command.getAdapter(DisplayableData.class);
        data.setDescription(resourcesForQueryLabel);
        command.setSaveable(false);
        Activator.executeSearch((Command)command);
        Debug.exit((Logger)logger, (String)RegionAction.class.getName(), (String)"executeRegionQuery");
    }
}

