/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.actions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.ia.commands.FindPlatformsAndApplicationsUsingResourceCommand;
import com.ibm.cics.ia.commands.QueryCommand;
import com.ibm.cics.ia.controller.DisplayableData;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.actions.Messages;
import com.ibm.cics.ia.ui.actions.MoreRegionsAction;
import java.text.MessageFormat;
import java.util.logging.Logger;
import org.eclipse.jface.action.IAction;

public class MoreRegionsUsedByAppAction
extends MoreRegionsAction {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(MoreRegionsUsedByAppAction.class.getPackage().getName());
    private boolean collectPrograms = false;
    private boolean collectTransactions = true;

    public MoreRegionsUsedByAppAction() {
        super(Messages.getString("MoreRegionsUsedByAppAction.title"));
    }

    public MoreRegionsUsedByAppAction(Resource aResource) {
        super(aResource);
    }

    @Override
    public void run() {
        this.run((IAction)this);
    }

    @Override
    public void run(IAction action) {
        Debug.enter((Logger)logger, (String)MoreRegionsUsedByAppAction.class.getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Resource resource = this.getResource();
        if (resource == null) {
            return;
        }
        Region region = this.getRegion();
        if (this.returnCode != 1) {
            FindPlatformsAndApplicationsUsingResourceCommand findCommand = new FindPlatformsAndApplicationsUsingResourceCommand(region, null, resource);
            String description = region != null ? MessageFormat.format(Messages.getString("UsedByApplicationAction.SpecificRegion.title"), resource.toString(), region.getName()) : MessageFormat.format(Messages.getString("UsedByApplicationAction.AllRegions.title"), resource.toString());
            Presentation presentation = PresentationFactory.getInstance().createPresentation(description, "", "", (Selection)findCommand.getSelectionObject());
            QueryCommand command = new QueryCommand(presentation);
            command.setDescription(description);
            DisplayableData data = (DisplayableData)command.getAdapter(DisplayableData.class);
            data.setDescription(description);
            command.setSaveable(false);
            Activator.executeSearch((Command)command);
        }
        Debug.exit((Logger)logger, (String)MoreRegionsUsedByAppAction.class.getName(), (String)"run");
    }
}

