/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.actions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.Ciuspep2EntryPointsModel;
import com.ibm.cics.ia.model.Ciuspep3EntryPointsModel;
import com.ibm.cics.ia.model.CiuspepsEntryPointsModel;
import com.ibm.cics.ia.model.EntryPointsModel;
import com.ibm.cics.ia.model.Operation;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.ui.Ciuspep2EntryPointsPresenter;
import com.ibm.cics.ia.ui.Ciuspep3EntryPointsPresenter;
import com.ibm.cics.ia.ui.CiuspepsEntryPointsPresenter;
import com.ibm.cics.ia.ui.EntryPointsPage;
import com.ibm.cics.ia.ui.EntryPointsPageWithoutStoredProcInput;
import com.ibm.cics.ia.ui.EntryPointsViewImpl;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.MoreRegionsDialog;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class FindEntryPointsAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private static final Logger logger = Logger.getLogger(FindEntryPointsAction.class.getPackage().getName());
    private static final String CIUSPEP3_ACTION_ID = "com.ibm.cics.ia.ui.actions.createapplicationusingciuspep3";
    private Object resource;

    public void run(IAction action) {
        String helpContextId;
        String wizardTitle;
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Region region = null;
        if (action.getId() == null) {
            return;
        }
        if (action.getId().matches("com\\.ibm\\.cics\\.ia\\.ui\\.actions\\.createapplicationusingciuspep[s2]\\.specificregion")) {
            MoreRegionsDialog regionSelectionDialog = new MoreRegionsDialog(Display.getCurrent().getActiveShell(), (Resource)this.resource, Messages.getString("Popup.CreateApplication.SpecificRegion"), false);
            int returnCode = regionSelectionDialog.open();
            if (returnCode == 0) {
                region = regionSelectionDialog.getRegion();
            } else {
                Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"run");
                return;
            }
        }
        CiuspepsEntryPointsPresenter presenter = null;
        CiuspepsEntryPointsModel model = null;
        if (action.getId().startsWith("com.ibm.cics.ia.ui.actions.createapplicationusingciuspeps")) {
            wizardTitle = Messages.getString("ApplicationCreationWizard.title.ApplicationEntryPointsByResourceUsed");
            presenter = new CiuspepsEntryPointsPresenter();
            model = new CiuspepsEntryPointsModel((Resource)this.resource);
            helpContextId = "com.ibm.cics.ia.help.entrypoints_wizard_by_resource_used";
        } else if (action.getId().startsWith("com.ibm.cics.ia.ui.actions.createapplicationusingciuspep2")) {
            wizardTitle = this.resource instanceof Program ? Messages.getString("ApplicationCreationWizard.title.ApplicationEntryPointsByProgramResourceUsage") : (this.resource instanceof Transaction ? Messages.getString("ApplicationCreationWizard.title.ApplicationEntryPointsByTransactionResourceUsage") : Messages.getString("ApplicationCreationWizard.title.ApplicationEntryPointsByWebserviceResourceUsage"));
            presenter = new Ciuspep2EntryPointsPresenter();
            model = new Ciuspep2EntryPointsModel((Resource)this.resource);
            helpContextId = "com.ibm.cics.ia.help.entrypoints_wizard_by_resource_usage";
        } else if (action.getId().equals(CIUSPEP3_ACTION_ID)) {
            wizardTitle = action.getText();
            presenter = new Ciuspep3EntryPointsPresenter();
            model = new Ciuspep3EntryPointsModel(this.resource);
            helpContextId = "com.ibm.cics.ia.help.entrypoints_wizard_by_cloud_resource";
        } else {
            Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"run");
            return;
        }
        model.setRegionParam(region != null ? region.getName() : null);
        EntryPointsViewImpl view = new EntryPointsViewImpl(wizardTitle);
        if (action.getId().equals(CIUSPEP3_ACTION_ID)) {
            view.setEntryPointsPage(new EntryPointsPageWithoutStoredProcInput());
        } else {
            view.setEntryPointsPage(new EntryPointsPage());
        }
        presenter.setView(view);
        presenter.setModel((EntryPointsModel)model);
        view.setPresenter(presenter);
        if (action.getId().matches("com\\.ibm\\.cics\\.ia\\.ui\\.actions\\.createapplicationusingciuspeps\\.(specificregion|allregions)")) {
            view.getUpdatePage().setCombo1Label(Messages.getString("ApplicationCreationWizard.selectCallType"));
        } else if (action.getId().matches("com\\.ibm\\.cics\\.ia\\.ui\\.actions\\.createapplicationusingciuspep2\\.(specificregion|allregions)")) {
            view.getUpdatePage().setCombo1Label(Messages.getString("ApplicationCreationWizard.selectObjectType2"));
        }
        model.setCicsTsLevel(EntryPointsModel.CicsTsLevel.LEVEL_51);
        view.show();
        view.getUpdatePage().setCicsTsLevel(0);
        view.getUpdatePage().setHelpContextId(helpContextId);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"run");
    }

    public void selectionChanged(IAction action, ISelection selection) {
        StructuredSelection structuredSelection;
        Object firstElement;
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"selectionChanged", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (selection instanceof StructuredSelection && ((firstElement = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof Resource || firstElement instanceof Operation)) {
            this.resource = firstElement;
        }
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"selectionChanged");
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

