/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.actions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.StoredProcedureCommand;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.dbfunc.model.StoredProcedure;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.storedproc.ProcedureCIUSPCFL;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.NavigatorView;
import com.ibm.cics.ia.ui.TypeValueDialog;
import com.ibm.cics.ia.ui.UserCommandFlowView;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;

public class DeleteCommandFlowDataAction
extends Action {
    static final String COPYRIGHT = "Licensed Materials - (c) Copyright HCL Technologies Ltd. *2025.";
    private static final Logger logger = Logger.getLogger(DeleteCommandFlowDataAction.class.getPackage().getName());
    public NavigatorView navigatorView;
    public String selectedCommandFlowId = "";
    public UserCommandFlowView userCommandFlowView;

    public DeleteCommandFlowDataAction(String actionName, NavigatorView navigatorView, UserCommandFlowView userCommandFlowView) {
        super(actionName);
        this.navigatorView = navigatorView;
        this.userCommandFlowView = userCommandFlowView;
    }

    public void run() {
        Debug.enter((Logger)logger, (String)DeleteCommandFlowDataAction.class.getName(), (String)"execute", (Object)("Thread ID: " + Thread.currentThread().getId()));
        MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 200);
        if (this.navigatorView != null && this.navigatorView.getTree().getSelection().length > 0) {
            this.selectedCommandFlowId = this.navigatorView.getTree().getSelection()[0].getText();
        }
        final String taskName = MessageFormat.format(Messages.getString("DeleteData"), this.selectedCommandFlowId);
        messageBox.setText(taskName);
        messageBox.setMessage(taskName);
        int result = messageBox.open();
        if (result == 64) {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
            try {
                dialog.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        Debug.enter((Logger)logger, (String)"DeleteCommandFlowDataAction.execute().ProgressMonitorDialog", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                        monitor.beginTask(taskName, -1);
                        StoredProcedureCommand command = new StoredProcedureCommand(){
                            private SelectionObject selectionObject;

                            public Object processRow(ResultSet resultSet) throws SQLException {
                                return null;
                            }

                            public SelectionObject getSelectionObject() {
                                return this.selectionObject == null ? (this.selectionObject = new ProcedureCIUSPCFL().getSelectionObject("C", (this).DeleteCommandFlowDataAction.this.selectedCommandFlowId)) : this.selectionObject;
                            }
                        };
                        command.setCategory("com.ibm.cics.ia.connection.db2");
                        command.setAsync(false);
                        command.start();
                        DeleteCommandFlowDataAction.this.updateUI(DeleteCommandFlowDataAction.this.selectedCommandFlowId, ((StoredProcedure)command.getSelectionObject()).getOutputValues());
                        monitor.done();
                        Debug.exit((Logger)logger, (String)"DeleteCommandFlowDataAction.execute().ProgressMonitorDialog", (String)"run");
                    }
                });
            }
            catch (InvocationTargetException e) {
                Debug.warning((Logger)logger, (String)DeleteCommandFlowDataAction.class.getName(), (String)"execute", (Throwable)e, new HashMap());
                IAPlugin.getDefault().logError("Unable to delete data", (Throwable)e);
            }
            catch (InterruptedException e) {
                Debug.warning((Logger)logger, (String)DeleteCommandFlowDataAction.class.getName(), (String)"execute", (Throwable)e, new HashMap());
                IAPlugin.getDefault().logError("Unable to delete data", (Throwable)e);
            }
        }
        if (result == 64) {
            this.userCommandFlowView.refresh(new Action(){});
        }
        Debug.exit((Logger)logger, (String)DeleteCommandFlowDataAction.class.getName(), (String)"execute");
    }

    private void updateUI(final String commandFlowId, final Map<String, Object> nameToValue) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Debug.enter((Logger)logger, (String)"DeleteCommandFlowDataAction.updateUI.syncExec.Runnable()", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                String title = MessageFormat.format(Messages.getString("DeleteData.completed.title"), commandFlowId);
                String messagePrefix = "DeleteData.completed.msg";
                String message = Messages.getString(messagePrefix);
                TypeValueDialog dlg = new TypeValueDialog(Display.getCurrent().getActiveShell(), nameToValue, title, message, String.valueOf(messagePrefix) + ".");
                dlg.open();
                Debug.exit((Logger)logger, (String)"DeleteCommandFlowDataAction.updateUI.syncExec.Runnable()", (String)"run");
            }
        });
    }
}

