/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.actions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ep.editor.AutoCreateEventBinding;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.ui.MoreRegionsDialog;
import com.ibm.cics.ia.ui.MoreResourcesDialog;
import com.ibm.cics.ia.ui.actions.Messages;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class CreateCommandEventAction
extends Action
implements IWorkbenchWindowActionDelegate {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CreateCommandEventAction.class.getPackage().getName());
    private static final String RESOURCE_TYPE_STUB = "TEXT";
    private static final String RESOURCE_NAME_STUB = "";
    private final String commandName;
    private List<Resource> resources;

    public CreateCommandEventAction(String commandName, List<Resource> resources) {
        this.commandName = commandName;
        this.resources = resources;
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        Debug.enter((Logger)logger, (String)CreateCommandEventAction.class.getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String capturePoint = this.getId();
        Calendar calendar = Calendar.getInstance();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 2);
        Region region = null;
        Resource resource = null;
        if (this.resources.size() == 1) {
            resource = this.resources.get(0);
        } else {
            MoreResourcesDialog resourceDialog = new MoreResourcesDialog(Display.getCurrent().getActiveShell(), this.resources, Messages.getString("MoreResourcesDialog.message"));
            if (resourceDialog.open() == 0) {
                resource = resourceDialog.getResource();
            } else {
                Debug.exit((Logger)logger, (String)CreateCommandEventAction.class.getName(), (String)"run");
                return;
            }
        }
        List regions = resource.getRegions();
        if (regions.size() == 1) {
            region = (Region)regions.get(0);
        } else {
            MoreRegionsDialog regionDialog = new MoreRegionsDialog(Display.getCurrent().getActiveShell(), regions, Messages.getString("MoreRegionsDialog.message"), false);
            if (regionDialog.open() == 0) {
                region = regionDialog.getRegion();
            } else {
                Debug.exit((Logger)logger, (String)CreateCommandEventAction.class.getName(), (String)"run");
                return;
            }
        }
        Object[] inserts = new String[]{RESOURCE_TYPE_STUB, RESOURCE_NAME_STUB, region.toString(), dateFormat.format(calendar.getTime())};
        String description = MessageFormat.format(Messages.getString("CreateEventAction.text"), inserts);
        HashMap m = new HashMap();
        AutoCreateEventBinding autoCreateEventBinding = new AutoCreateEventBinding(capturePoint, description);
        if (resource instanceof Program) {
            Program program = (Program)resource;
            autoCreateEventBinding.setProgram(program.getName());
            Map interactions = program.getTargetInteractionsForTransaction();
            Set transactions = interactions.keySet();
            if (transactions.size() == 1) {
                Transaction transaction = (Transaction)transactions.toArray()[0];
                autoCreateEventBinding.setTransid(transaction.getName());
            }
        }
        autoCreateEventBinding.create();
        Debug.exit((Logger)logger, (String)CreateCommandEventAction.class.getName(), (String)"run");
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

