/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.actions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.controller.AffinityReportGenerator;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.ui.CreateAffinityReportWizard;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class AffinityReportAction
extends Action
implements IWorkbenchWindowActionDelegate {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2013, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(AffinityReportAction.class.getPackage().getName());
    private Region[] regions;
    public static final String ID = "com.ibm.cics.ia.action.report.affinity";

    public AffinityReportAction(Region[] regions) {
        this.regions = regions;
    }

    public AffinityReportAction(Region region) {
        this.regions = new Region[]{region};
    }

    public AffinityReportAction() {
    }

    public void run() {
        this.run(null);
    }

    public void run(IAction action) {
        Debug.enter((Logger)logger, (String)AffinityReportAction.class.getName(), (String)"run", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId()});
        CreateAffinityReportWizard wizard = new CreateAffinityReportWizard(this.regions);
        WizardDialog wizardDialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        wizardDialog.create();
        int result = wizardDialog.open();
        if (result == 0) {
            AffinityReportGenerator generator = new AffinityReportGenerator(wizard.getRegions(), wizard.getAffinityTypes(), wizard.getRootFolder(), wizard.getTitle(), wizard.getDescription(), wizard.isAddTimeStamp());
            generator.schedule();
        }
        Debug.exit((Logger)logger, (String)AffinityReportAction.class.getName(), (String)"run");
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Debug.enter((Logger)logger, (String)AffinityReportAction.class.getName(), (String)"selectionChanged", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "selection: " + selection});
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() != 1) {
                action.setEnabled(false);
            } else if (action instanceof Action) {
                Object firstElement = structuredSelection.getFirstElement();
                if (firstElement instanceof Region) {
                    this.regions = new Region[]{(Region)firstElement};
                } else {
                    action.setEnabled(false);
                }
            } else {
                action.setEnabled(false);
                this.regions = null;
            }
        }
        Debug.exit((Logger)logger, (String)AffinityReportAction.class.getName(), (String)"selectionChanged");
    }

    public void dispose() {
        this.regions = null;
    }

    public void init(IWorkbenchWindow window) {
    }
}

