/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.ui.Messages;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public class VerbFormatter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static Map verbsToDescriptions = new HashMap();
    static Map verbInversesToDescriptions;

    static {
        verbsToDescriptions.put("LINK", Messages.getString("VerbFormatter.verb.links"));
        verbsToDescriptions.put("LOAD", Messages.getString("VerbFormatter.verb.loads"));
        verbsToDescriptions.put("START", Messages.getString("VerbFormatter.verb.starts"));
        verbsToDescriptions.put("XCTL", Messages.getString("VerbFormatter.verb.XCTL"));
        verbsToDescriptions.put("RETURN", Messages.getString("VerbFormatter.verb.RETURN"));
        verbInversesToDescriptions = new HashMap();
        verbInversesToDescriptions.put("LINK", Messages.getString("VerbFormatter.verb.inverse.linked"));
        verbInversesToDescriptions.put("LOAD", Messages.getString("VerbFormatter.verb.inverse.loaded"));
        verbInversesToDescriptions.put(Resource.READ_UPD, Messages.getString("VerbFormatter.verb.inverse.readupd"));
        verbInversesToDescriptions.put("START", Messages.getString("VerbFormatter.verb.inverse.started"));
        verbInversesToDescriptions.put("READQ", Messages.getString("VerbFormatter.verb.inverse.readq"));
        verbInversesToDescriptions.put("WRITEQ", Messages.getString("VerbFormatter.verb.inverse.writeq"));
        verbInversesToDescriptions.put("DELETEQ", Messages.getString("VerbFormatter.verb.inverse.deleteq"));
    }

    public static String format(String verbName, String target) {
        String result = (String)verbInversesToDescriptions.get(verbName);
        return result != null ? VerbFormatter.formatInverse(verbName) : VerbFormatter.formatDirect(verbName, target);
    }

    public static String formatDirect(String verbName, String target) {
        String result = (String)verbsToDescriptions.get(verbName);
        return result != null ? MessageFormat.format(result, target) : VerbFormatter.toLowercaseCapitalizeFirstLetter(verbName);
    }

    public static String formatInverse(String verbName) {
        String result = (String)verbInversesToDescriptions.get(verbName);
        return result != null ? MessageFormat.format(Messages.getString("VerbFormatter.by"), result) : VerbFormatter.toLowercaseCapitalizeFirstLetter(verbName);
    }

    private static String toLowercaseCapitalizeFirstLetter(String verbName) {
        StringReader reader = new StringReader(verbName);
        StringBuffer result = new StringBuffer(verbName.length());
        try {
            int character = reader.read();
            result.append(Character.toUpperCase((char)character));
            character = reader.read();
            while (character != -1) {
                result.append(Character.toLowerCase((char)character));
                character = reader.read();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result.toString();
    }
}

