/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.command.EngineShell;
import com.ibm.cics.dbfunc.command.SQLCommand;
import com.ibm.cics.eclipse.common.ui.JobWithCancelingSupport;
import com.ibm.cics.ia.commands.FindUserCommandFlowRunsCommand;
import com.ibm.cics.ia.model.ProgramFlowsModel;
import com.ibm.cics.ia.model.ProgramFlowsModelImpl;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.DefaultRetrieveMorePresenterImpl;
import com.ibm.cics.ia.ui.DefaultRetrieveMoreViewImpl;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.LabelProviderFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.NavigatorView;
import com.ibm.cics.ia.ui.ProgramFlowsPresenterImpl;
import com.ibm.cics.ia.ui.ProgramFlowsViewInput;
import com.ibm.cics.ia.ui.RetrieveMorePresenter;
import com.ibm.cics.ia.ui.RetrieveMoreView;
import com.ibm.cics.ia.ui.UIUtilities;
import com.ibm.cics.ia.ui.UserCommandFlowViewHelper;
import com.ibm.cics.ia.ui.actions.DeleteCommandFlowDataAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;

public class UserCommandFlowView {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(UserCommandFlowView.class.getPackage().getName());
    public static final String RESOURCE = "RESOURCE";
    private static final String CHILDREN = "CHILDREN";
    private static final String ITEMTYPE = "ITEMTYPE";
    private String taskName = "";
    private boolean sortByTime;
    private Display display;
    private Composite parent;
    private Tree usersTree;
    private Action sortByTimeAction;
    private Action refreshAction;
    private Action programFlowAction;
    private Action deleteAssociatedData;
    private TreeItem dummyTreeItem;
    private SQLCommand sqlCommand;
    private EngineShell.EngineListener commandListener;
    private ConnectionServiceListener connectionServiceListener;
    private Label descLabel;
    private int resultsCount;
    private TreeItem root;
    private NavigatorView navigatorView;
    private RetrieveMoreView retrieveMoreCommandFlowRunsView;
    private RetrieveMorePresenter retrieveMoreCommandFlowRunsPresenter;

    public UserCommandFlowView(NavigatorView navigatorView) {
        this.navigatorView = navigatorView;
        this.usersTree = navigatorView.getTree();
        this.root = UIUtilities.createTreeItem(this.usersTree, Messages.getString("NavigatorView.category.userCommandFlow"), ImageFactory.getUserCommandFlowImage());
    }

    public void createPartControl(Composite parent) {
        Debug.enter((Logger)logger, (String)UserCommandFlowView.class.getName(), (String)"createPartControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.parent = parent;
        this.display = parent.getDisplay();
        this.retrieveMoreCommandFlowRunsView = new DefaultRetrieveMoreViewImpl(this.usersTree, (IViewPart)this.navigatorView);
        this.retrieveMoreCommandFlowRunsPresenter = new DefaultRetrieveMorePresenterImpl(this.retrieveMoreCommandFlowRunsView);
        this.retrieveMoreCommandFlowRunsView.setPresenter(this.retrieveMoreCommandFlowRunsPresenter);
        if (NavigatorView.isConnected()) {
            this.dummyTreeItem = UIUtilities.createDummyTreeItem(this.root);
        }
        this.createActions();
        this.connectionServiceListener = this.getConnectionServiceListener();
        ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(this.connectionServiceListener);
        Debug.exit((Logger)logger, (String)UserCommandFlowView.class.getName(), (String)"createPartControl");
    }

    public void setFocus() {
    }

    public void dispose() {
        Debug.enter((Logger)logger, (String)UserCommandFlowView.class.getName(), (String)"dispose", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.connectionServiceListener != null) {
            this.connectionServiceListener.makeStale();
        }
        Debug.exit((Logger)logger, (String)UserCommandFlowView.class.getName(), (String)"dispose");
    }

    public void init(IViewSite site) throws PartInitException {
    }

    private String getTaskName() {
        return this.taskName;
    }

    private void createActions() {
        this.sortByTimeAction = new Action(Messages.getString("UserCommandFlowView.groupByTime"), ImageDescriptor.createFromImage((Image)ImageFactory.getTimeStampImage())){

            public void run() {
                UserCommandFlowView.this.sortByTime = this.isChecked();
                UserCommandFlowView.this.clear();
                UserCommandFlowView.this.runSearch();
            }

            public int getStyle() {
                return 2;
            }
        };
        this.refreshAction = new Action(Messages.getString("UserCommandFlowView.refreshButtonText"), ImageDescriptor.createFromImage((Image)ImageFactory.getRefreshImage())){

            public void run() {
                UserCommandFlowView.this.refresh(new Action(){});
            }
        };
        this.programFlowAction = new Action(Messages.getString("UserCommandFlowView.programFlow"), ImageDescriptor.createFromImage((Image)ImageFactory.getResourceConnectionsImage())){

            public void run() {
                ProgramFlowsPresenterImpl presenter = ProgramFlowsPresenterImpl.getInstance();
                ProgramFlowsModelImpl model = ProgramFlowsModelImpl.getInstance();
                presenter.setModel((ProgramFlowsModel)model);
                ProgramFlowsViewInput input = new ProgramFlowsViewInput(presenter);
                Activator.openEditor(input, "com.ibm.cics.ia.ui.ProgramFlowsViewImpl", false);
            }
        };
        this.deleteAssociatedData = new DeleteCommandFlowDataAction(Messages.getString("UserCommandFlowView.deleteAssociatedData"), this.navigatorView, this);
    }

    public void refresh(final Action afterRefreshAction) {
        this.clear();
        Job runJob = this.runSearch();
        if (runJob != null) {
            runJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    afterRefreshAction.run();
                }
            });
        } else {
            afterRefreshAction.run();
        }
    }

    private ConnectionServiceListener getConnectionServiceListener() {
        return new ConnectionServiceListener(){

            public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
                if ("com.ibm.cics.ia.connection.db2".equals(event.getConnectionCategoryId())) {
                    if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                        this.connected();
                    } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                        this.disconnected();
                    }
                }
            }

            public void connected() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        UserCommandFlowView.this.dummyTreeItem = NavigatorView.createDummyIfNotExists(UserCommandFlowView.this.dummyTreeItem, UserCommandFlowView.this.root);
                    }
                });
            }

            public void disconnected() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        UserCommandFlowView.this.clear();
                    }
                });
            }
        };
    }

    private void clear() {
        HashMap childItems = new HashMap();
        this.root.setData(CHILDREN, childItems);
        this.clearUIElements();
        if (this.sqlCommand != null && this.sqlCommand.status() == 0) {
            this.sqlCommand.removeListener(this.getCommandListener());
            this.sqlCommand.cancel();
        }
        this.sqlCommand = null;
        if (this.navigatorView.getSelectionProvider() != null) {
            this.navigatorView.getSelectionProvider().setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private void clearUIElements() {
        Debug.enter((Logger)logger, (String)UserCommandFlowView.class.getName(), (String)"clearUIElements", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (!this.parent.isDisposed()) {
            if (this.dummyTreeItem != null) {
                this.dummyTreeItem.dispose();
            }
            this.root.removeAll();
            this.resultsCount = 0;
            if (this.retrieveMoreCommandFlowRunsView != null) {
                this.retrieveMoreCommandFlowRunsView.hide();
            }
            this.parent.setCursor(null);
        }
        Debug.exit((Logger)logger, (String)UserCommandFlowView.class.getName(), (String)"clearUIElements");
    }

    public Job runSearch() {
        Debug.enter((Logger)logger, (String)UserCommandFlowView.class.getName(), (String)"runSearch", (Object)("Thread ID: " + Thread.currentThread().getId()));
        IConnectable resourceManager = ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.ia.connection.db2");
        if (!resourceManager.isConnected()) {
            return null;
        }
        if (this.usersTree != null) {
            this.dummyTreeItem = UIUtilities.createDummyTreeItem(this.root);
            this.sqlCommand = new FindUserCommandFlowRunsCommand();
            this.sqlCommand.addListener(this.getCommandListener());
            this.retrieveMoreCommandFlowRunsPresenter.setCommand((Command)this.sqlCommand);
            this.parent.setCursor(this.parent.getDisplay().getSystemCursor(3));
            JobWithCancelingSupport findResourceJob = new JobWithCancelingSupport(this.getTaskName()){

                protected void cancelingSub() {
                    if (UserCommandFlowView.this.sqlCommand != null) {
                        UserCommandFlowView.this.sqlCommand.cancel();
                    }
                    IAPlugin.getDefault().taskEnded();
                }

                protected IStatus runSub(IProgressMonitor monitor) {
                    Debug.enter((Logger)logger, (String)"UserCommandFlowView.runSearch().findResourcesJob", (String)"runSub", (Object)("Thread ID: " + Thread.currentThread().getId()));
                    Activator.getDefault().ensureConnected();
                    UserCommandFlowView.this.refreshAction.setEnabled(false);
                    UserCommandFlowView.this.sortByTimeAction.setEnabled(false);
                    monitor.beginTask(UserCommandFlowView.this.getTaskName(), -1);
                    if (UserCommandFlowView.this.sqlCommand != null) {
                        UserCommandFlowView.this.sqlCommand.setAsync(false);
                        UserCommandFlowView.this.sqlCommand.start();
                    }
                    monitor.done();
                    IAPlugin.getDefault().taskEnded();
                    UserCommandFlowView.this.refreshAction.setEnabled(true);
                    UserCommandFlowView.this.sortByTimeAction.setEnabled(true);
                    Debug.exit((Logger)logger, (String)"UserCommandFlowView.runSearch().findResourcesJob", (String)"runSub");
                    return Status.OK_STATUS;
                }
            };
            this.retrieveMoreCommandFlowRunsPresenter.setTaskName(this.getTaskName());
            findResourceJob.schedule();
            Debug.exit((Logger)logger, (String)UserCommandFlowView.class.getName(), (String)"runSearch");
            return findResourceJob;
        }
        Debug.exit((Logger)logger, (String)UserCommandFlowView.class.getName(), (String)"runSearch");
        return null;
    }

    private EngineShell.EngineListener getCommandListener() {
        if (this.commandListener == null) {
            this.commandListener = new EngineShell.EngineListener(){

                public void statusUpdate(EngineShell.EngineStatus es) {
                    switch (es) {
                        case Paused: {
                            UserCommandFlowView.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!UserCommandFlowView.this.parent.isDisposed()) {
                                        if (UserCommandFlowView.this.retrieveMoreCommandFlowRunsView != null) {
                                            UserCommandFlowView.this.retrieveMoreCommandFlowRunsView.show();
                                        }
                                        UserCommandFlowView.this.parent.setCursor(null);
                                    }
                                }
                            });
                            break;
                        }
                        case Complete: {
                            UserCommandFlowView.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!UserCommandFlowView.this.parent.isDisposed()) {
                                        if (UserCommandFlowView.this.retrieveMoreCommandFlowRunsView != null) {
                                            UserCommandFlowView.this.retrieveMoreCommandFlowRunsView.hide();
                                        }
                                        if (UserCommandFlowView.this.parent != null && !UserCommandFlowView.this.parent.isDisposed()) {
                                            UserCommandFlowView.this.parent.setCursor(null);
                                            if (UserCommandFlowView.this.dummyTreeItem != null) {
                                                UserCommandFlowView.this.dummyTreeItem.dispose();
                                                UserCommandFlowView.this.dummyTreeItem = null;
                                            }
                                        }
                                    }
                                }
                            });
                            break;
                        }
                        case Error: {
                            UserCommandFlowView.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!UserCommandFlowView.this.parent.isDisposed()) {
                                        if (UserCommandFlowView.this.retrieveMoreCommandFlowRunsView != null) {
                                            UserCommandFlowView.this.retrieveMoreCommandFlowRunsView.hide();
                                        }
                                        UserCommandFlowView.this.parent.setCursor(null);
                                        if (UserCommandFlowView.this.dummyTreeItem != null) {
                                            UserCommandFlowView.this.dummyTreeItem.dispose();
                                            UserCommandFlowView.this.dummyTreeItem = null;
                                        }
                                    }
                                }
                            });
                        }
                        case Cancelled: {
                            UserCommandFlowView.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!UserCommandFlowView.this.parent.isDisposed()) {
                                        if (UserCommandFlowView.this.retrieveMoreCommandFlowRunsView != null) {
                                            UserCommandFlowView.this.retrieveMoreCommandFlowRunsView.hide();
                                        }
                                        UserCommandFlowView.this.parent.setCursor(null);
                                        if (UserCommandFlowView.this.dummyTreeItem != null) {
                                            UserCommandFlowView.this.dummyTreeItem.dispose();
                                            UserCommandFlowView.this.dummyTreeItem = null;
                                        }
                                    }
                                }
                            });
                        }
                    }
                }

                public void notifyResultCount(int count) {
                }

                public void dataAvailable(final Collection<Object> items) {
                    if (UserCommandFlowView.this.display != null) {
                        UserCommandFlowView.this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    if (items.size() > 0) {
                                        UserCommandFlowView.this.insertResources(items);
                                    }
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        });
                    }
                }
            };
        }
        return this.commandListener;
    }

    public void insertResources(Collection<Object> items) {
        Debug.enter((Logger)logger, (String)UserCommandFlowView.class.getName(), (String)"insertResources", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.dummyTreeItem != null) {
            this.dummyTreeItem.dispose();
            this.dummyTreeItem = null;
        }
        Iterator<Object> iterator = items.iterator();
        HashMap columnIndices = new HashMap();
        UserCommandFlowViewHelper helper = new UserCommandFlowViewHelper();
        String[] treeNodes = new String[]{"OWNER_USERID", "CMDFLOW_ID", "USERID", "CMD_TIME_LOCAL", "TASKID"};
        if (this.sortByTime) {
            treeNodes = new String[]{"OWNER_USERID", "CMD_TIME_LOCAL", "CMDFLOW_ID", "USERID", "TASKID"};
        }
        while (iterator.hasNext()) {
            Object nextItem = iterator.next();
            if (!(nextItem instanceof Map)) continue;
            Map map = (Map)nextItem;
            TreeItem parentItem = this.root;
            int i = 0;
            while (i < 5) {
                Map childItems = (Map)parentItem.getData(CHILDREN);
                TreeItem childItem = (TreeItem)childItems.get(map.get(treeNodes[i]));
                if (childItem == null || childItem.isDisposed()) {
                    childItem = new TreeItem(parentItem, 0);
                    HashMap childItems2 = new HashMap();
                    childItem.setData(CHILDREN, childItems2);
                    childItem.setData(RESOURCE, map.get(treeNodes[i]));
                    childItem.setData(ITEMTYPE, (Object)treeNodes[i]);
                    LabelProvider labelProvider = LabelProviderFactory.getLabelProvider(treeNodes[i]);
                    childItem.setImage(labelProvider.getImage((Object)treeNodes[i]));
                    childItem.setText(labelProvider.getText((Object)helper.getDisplayText(treeNodes[i], map)));
                    childItems.put(map.get(treeNodes[i]), childItem);
                    this.retrieveMoreCommandFlowRunsView.setParentItem(parentItem);
                }
                parentItem = childItem;
                ++i;
            }
        }
        this.resultsCount += items.size();
        Debug.exit((Logger)logger, (String)UserCommandFlowView.class.getName(), (String)"insertResources");
    }

    public TreeItem getRoot() {
        return this.root;
    }

    public void buildPopupMenu(IMenuManager manager, TreeItem[] selectedItems) {
        TreeItem item;
        Object itemData;
        if (selectedItems.length > 0 && selectedItems[0] == this.root) {
            manager.add((IAction)this.sortByTimeAction);
            manager.add((IAction)this.refreshAction);
            manager.add((IAction)this.programFlowAction);
        } else if (selectedItems.length > 0 && (itemData = (item = selectedItems[0]).getData(ITEMTYPE)) == "CMDFLOW_ID") {
            manager.add((IAction)this.deleteAssociatedData);
        }
    }

    public void rootExpanded() {
        if (NavigatorView.canRunCommand(this.sqlCommand) && UIUtilities.widgetExists((Widget)this.dummyTreeItem) && NavigatorView.isConnected()) {
            this.clear();
            this.runSearch();
        }
    }

    public void selected() {
        this.navigatorView.createDummyTopComposite();
    }
}

