/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.ia.controller.DisplayableData;
import com.ibm.cics.ia.model.CommandExecution;
import com.ibm.cics.ia.model.ExecutionAnalyzer;
import com.ibm.cics.ia.query.QueryResultRow;
import com.ibm.cics.ia.query.SQLDefinitions;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.LabelProviderFactory;
import com.ibm.cics.ia.ui.Messages;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public final class UIUtilities {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String M_SEARCH = "M_SEARCH";
    public static final String RESOURCE = "RESOURCE";
    public static final String REGION = "REGION";
    public static final String COLLECTIONID = "COLLECTIONID";
    public static final String TRANSACTION = "TRANSACTION";
    public static final int DEFAULT_COMMAND_LABEL_LENGTH = 50;
    public static final String SEARCHING_ITEM_TEXT = Messages.getString("Searching.progress.text");
    private static Comparator treeSorter;
    private static Comparator treeTextComparator;
    private static Comparator ebcdicComparator;
    public static final Integer NO_WIDTH_SPECIFIED;

    static {
        ebcdicComparator = new IAUtilities.EBCDICStringComparator();
        NO_WIDTH_SPECIFIED = new Integer(-1);
        treeSorter = new Comparator(){

            public int compare(Object firstTreeItem, Object secondTreeItem) {
                return ebcdicComparator.compare(((TreeItem)firstTreeItem).getText(), ((TreeItem)secondTreeItem).getText());
            }
        };
        treeTextComparator = new Comparator(){

            public int compare(Object treeItem, Object textOfItemToInsert) {
                return ebcdicComparator.compare(((TreeItem)treeItem).getText(), textOfItemToInsert);
            }
        };
    }

    private UIUtilities() {
    }

    public static String asFormattedDescription(Command aCommand, DisplayableData displayableData) {
        return UIUtilities.asFormattedDescription(aCommand, displayableData, 50);
    }

    public static String asFormattedDescription(Command aCommand, DisplayableData displayableData, int maxTextLength) {
        return UIUtilities.asFormattedDescription(displayableData, maxTextLength);
    }

    public static String asFormattedDescription(DisplayableData displayableData) {
        return UIUtilities.asFormattedDescription(displayableData, 50);
    }

    public static String asFormattedDescription(DisplayableData displayableData, int maxTextLength) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(IAUtilities.shorten((String)displayableData.getDescription(), (int)maxTextLength));
        if (displayableData.getSize() != 0) {
            buffer.append(" (");
            buffer.append(displayableData.getSize());
            buffer.append(")");
        }
        return buffer.toString();
    }

    public static void ensureHelpInitialized() {
        if (JFaceResources.getImage((String)"dialog_help_image") == null) {
            JFaceResources.getImageRegistry().put("dialog_help_image", ImageFactory.getHelpLinkImage());
        }
    }

    public static void helpPressed(Control aControl) {
        while (aControl != null) {
            if (aControl.isListening(28)) {
                aControl.notifyListeners(28, new Event());
                break;
            }
            aControl = aControl.getParent();
        }
    }

    public static void helpPressed() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (shell != null) {
            Control focusControl = shell.getDisplay().getFocusControl();
            UIUtilities.helpPressed(focusControl);
        }
    }

    public static void openConnectionPreferences() {
        String prefID = "com.ibm.cics.ia.ui.preferencepage";
        PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)prefID, (String[])new String[]{prefID}, null).open();
    }

    public static String getClipboardData(String[] columnNames, List results) {
        StringBuffer buffer = new StringBuffer();
        String[] columns = columnNames;
        LabelProvider[] columnLabelProviders = new LabelProvider[columns.length];
        int i = 0;
        while (i < columns.length) {
            if (i > 0 & i < columns.length) {
                buffer.append(',');
            }
            buffer.append(SQLDefinitions.getColumnDescription((String)columns[i]));
            columnLabelProviders[i] = LabelProviderFactory.getLabelProvider(columns[i]);
            ++i;
        }
        buffer.append(IAUtilities.LINE_SEPARATOR);
        for (QueryResultRow row : results) {
            int i2 = 0;
            while (i2 < row.getData().length) {
                if (i2 > 0 && i2 < row.getData().length) {
                    buffer.append(',');
                }
                buffer.append(columnLabelProviders[i2].getText(row.getData()[i2]));
                ++i2;
            }
            buffer.append(IAUtilities.LINE_SEPARATOR);
        }
        return buffer.toString();
    }

    public static String getClipboardData(ExecutionAnalyzer analyzer) {
        StringBuffer buffer = new StringBuffer();
        String[] columns = analyzer.getColumns();
        LabelProvider[] columnLabelProviders = new LabelProvider[columns.length];
        int i = 0;
        while (i < columns.length) {
            if (i > 0 & i < columns.length) {
                buffer.append(',');
            }
            buffer.append(SQLDefinitions.getColumnDescription((String)columns[i]));
            columnLabelProviders[i] = LabelProviderFactory.getLabelProvider(columns[i]);
            ++i;
        }
        buffer.append(IAUtilities.LINE_SEPARATOR);
        List results = analyzer.getResults();
        if (results != null) {
            for (Object next : results) {
                if (!(next instanceof CommandExecution)) continue;
                buffer.append(((CommandExecution)next).getAsCopyString());
                buffer.append(IAUtilities.LINE_SEPARATOR);
            }
        }
        return buffer.toString();
    }

    public static void scheduleWorkbenchPartJob(IWorkbenchPart part, Job aJob) {
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)part.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        siteService.schedule(aJob, 0L, true);
    }

    public static TreeItem createTreeItem(Tree parentTree, String text, Image anImage) {
        TreeItem result = new TreeItem(parentTree, 0);
        result.setText(text);
        result.setImage(anImage);
        return result;
    }

    public static TreeItem createTreeItem(TreeItem parentTreeItem, String text, Image anImage) {
        TreeItem result = new TreeItem(parentTreeItem, 0);
        result.setText(text);
        result.setImage(anImage);
        return result;
    }

    public static TreeItem createEBCDICSortedTreeItem(Tree parentTree, String text, Image anImage) {
        TreeItem[] treeItems = parentTree.getItems();
        Arrays.sort(treeItems, treeSorter);
        int indexToInsert = Arrays.binarySearch(treeItems, text, treeTextComparator);
        TreeItem resultItem = null;
        resultItem = indexToInsert == -1 ? new TreeItem(parentTree, 0, 0) : (indexToInsert < 0 ? new TreeItem(parentTree, 0, 0 - indexToInsert - 1) : new TreeItem(parentTree, 0, indexToInsert - 1));
        resultItem.setText(text);
        resultItem.setImage(anImage);
        return resultItem;
    }

    public static TreeItem createEBCDICSortedTreeItem(TreeItem parent, String text, Image image) {
        TreeItem[] children = parent.getItems();
        Arrays.sort(children, treeSorter);
        int insertionPoint = Arrays.binarySearch(children, text, treeTextComparator);
        TreeItem resultItem = null;
        if (insertionPoint < 0) {
            resultItem = new TreeItem(parent, 0, 0 - insertionPoint - 1);
            resultItem.setText(text);
            resultItem.setImage(image);
            return resultItem;
        }
        return children[insertionPoint];
    }

    public static TreeItem createDummyTreeItem(Tree aTree) {
        TreeItem result = new TreeItem(aTree, 0);
        result.setImage(ImageFactory.getWaitingImage());
        result.setText(SEARCHING_ITEM_TEXT);
        return result;
    }

    public static TreeItem createDummyTreeItem(TreeItem aTreeItem) {
        TreeItem result = new TreeItem(aTreeItem, 0);
        result.setImage(ImageFactory.getWaitingImage());
        result.setText(SEARCHING_ITEM_TEXT);
        return result;
    }

    public static TableItem createDummyTableItem(Table aTable) {
        TableItem result = new TableItem(aTable, 0);
        result.setImage(ImageFactory.getWaitingImage());
        result.setText(SEARCHING_ITEM_TEXT);
        return result;
    }

    public static void cancel(Command aCommand) {
        int currentStatus = aCommand.status();
        if (currentStatus != 1) {
            DisplayableData displayableData = DisplayableData.getDisplayableData((IAdaptable)aCommand);
            if (currentStatus != 2) {
                aCommand.cancel();
            }
            displayableData.setStatus(aCommand.status());
        }
    }

    public static void expandTree(Tree tree, boolean b) {
        tree.setVisible(false);
        TreeItem[] items = tree.getItems();
        int i = 0;
        while (i < items.length) {
            UIUtilities.expandTree(items[i], b);
            ++i;
        }
        tree.setVisible(true);
    }

    public static void expandTree(TreeItem treeItem, boolean b) {
        if (b) {
            treeItem.setExpanded(b);
        }
        TreeItem[] items = treeItem.getItems();
        int i = 0;
        while (i < items.length) {
            UIUtilities.expandTree(items[i], b);
            ++i;
        }
        if (!b) {
            treeItem.setExpanded(b);
        }
    }

    public static Map<String, String> getDisplayNameMap(String[] sqlNames) {
        TreeMap<Object, String> map = new TreeMap<Object, String>(Collator.getInstance());
        String[] stringArray = sqlNames;
        int n = sqlNames.length;
        int n2 = 0;
        while (n2 < n) {
            String sqlName = stringArray[n2];
            String columnDescription = SQLDefinitions.getColumnDescription((String)sqlName);
            map.put(columnDescription, sqlName);
            ++n2;
        }
        return map;
    }

    public static Map<String, String> getCICSDisplayNameMap(String[] sqlNames) {
        TreeMap<Object, String> map = new TreeMap<Object, String>(Collator.getInstance());
        String[] stringArray = sqlNames;
        int n = sqlNames.length;
        int n2 = 0;
        while (n2 < n) {
            String sqlName = stringArray[n2];
            String columnDescription = SQLDefinitions.getCICSColumnDescription((String)sqlName);
            map.put(columnDescription, sqlName);
            ++n2;
        }
        return map;
    }

    public static LinkedHashMap<String, Integer> getColumns(String columnNames, String columnWidths) {
        LinkedHashMap<String, Integer> columns = new LinkedHashMap<String, Integer>();
        String[] names = columnNames.split(",");
        String[] widths = columnWidths.split(",");
        int i = 0;
        while (i < names.length) {
            Integer width;
            if (i < widths.length) {
                try {
                    width = Integer.parseInt(widths[i]);
                }
                catch (NumberFormatException ex) {
                    width = NO_WIDTH_SPECIFIED;
                }
            } else {
                width = NO_WIDTH_SPECIFIED;
            }
            columns.put(names[i], width);
            ++i;
        }
        return columns;
    }

    public static int getMaxPixelLength(List<String> texts, Font font) {
        class LengthCalculator
        implements Runnable {
            private int maxLength;
            private final /* synthetic */ Font val$font;
            private final /* synthetic */ List val$texts;

            LengthCalculator(Font font, List list) {
                this.val$font = font;
                this.val$texts = list;
            }

            @Override
            public void run() {
                GC gc = new GC((Drawable)Display.getDefault());
                gc.setFont(this.val$font);
                for (String text : this.val$texts) {
                    if (text == null) continue;
                    Point currentTextArea = gc.stringExtent(text);
                    if (this.maxLength >= currentTextArea.x) continue;
                    this.maxLength = currentTextArea.x;
                }
                gc.dispose();
            }

            public int getMaxLength() {
                return this.maxLength;
            }
        }
        LengthCalculator calculator = new LengthCalculator(font, texts);
        Display.getDefault().syncExec((Runnable)calculator);
        return calculator.getMaxLength();
    }

    public static int getPixelLength(final String text, final Font font) {
        final Point extent = new Point(0, 0);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                GC gc = new GC((Drawable)Display.getDefault());
                gc.setFont(font);
                if (text != null) {
                    extent.x = gc.stringExtent((String)text).x;
                }
                gc.dispose();
            }
        });
        return extent.x;
    }

    public static TreeItem getRoot(TreeItem item) {
        while (item.getParentItem() != null) {
            item = item.getParentItem();
        }
        return item;
    }

    public static boolean widgetExists(Widget widget) {
        return widget != null && !widget.isDisposed();
    }

    public static ToolBar createToolBar(Composite parent) {
        ToolBar toolbar = new ToolBar(parent, 8388928);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 131072;
        toolbar.setLayoutData((Object)data);
        return toolbar;
    }

    static abstract class CopyListener
    implements KeyListener {
        CopyListener() {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if (e.stateMask == 262144 && (e.character == '\u0003' || e.keyCode == 0x1000009)) {
                this.copy();
            }
        }

        public abstract void copy();
    }

    static class FocusKeeper {
        private Composite lastFocused;
        private Composite defaultComposite;

        public FocusKeeper(Composite ... composites) {
            Composite[] compositeArray = composites;
            int n = composites.length;
            int n2 = 0;
            while (n2 < n) {
                final Composite composite = compositeArray[n2];
                composite.addFocusListener(new FocusListener(){

                    public void focusLost(FocusEvent e) {
                    }

                    public void focusGained(FocusEvent e) {
                        lastFocused = composite;
                    }
                });
                ++n2;
            }
        }

        public void setDefault(Composite composite) {
            this.defaultComposite = composite;
        }

        public boolean setFocus() {
            boolean focusSet = false;
            if (this.lastFocused != null && !this.lastFocused.isDisposed()) {
                focusSet = this.lastFocused.setFocus();
            }
            if (!focusSet && this.defaultComposite != null && !this.defaultComposite.isDisposed()) {
                focusSet = this.defaultComposite.setFocus();
            }
            return focusSet;
        }
    }
}

