/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.Messages;
import java.text.Collator;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TypeValueDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Map<String, Object> values;
    private String title;
    private String message;
    private String messagePrefix;

    public TypeValueDialog(Shell shell, Map<String, Object> values, String title, String message) {
        super(shell);
        this.values = values;
        this.title = title;
        this.message = message;
    }

    public TypeValueDialog(Shell shell, Map<String, Object> values, String title, String message, String messagePrefix) {
        this(shell, values, title, message);
        this.messagePrefix = messagePrefix;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.title);
        this.setMessage(this.message, 1);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Table table = new Table(composite, 67584);
        table.setLayoutData((Object)new GridData(1808));
        TableColumn name = new TableColumn(table, 16384);
        name.setText("Name");
        TableColumn value = new TableColumn(table, 16384);
        value.setText("Value");
        table.setHeaderVisible(true);
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            TableItem item = new TableItem(table, 0);
            if (IAUtilities.hasContent((String)this.messagePrefix)) {
                item.setText(0, Messages.getString(String.valueOf(this.messagePrefix) + entry.getKey()));
            } else {
                item.setText(0, entry.getKey());
            }
            item.setText(1, entry.getValue().toString());
        }
        this.sort(0, table);
        name.pack();
        value.pack();
        return composite;
    }

    private void sort(int columnIndex, Table table) {
        TableItem[] items = table.getItems();
        Collator collator = Collator.getInstance(Locale.getDefault());
        int i = 1;
        while (i < items.length) {
            String value1 = items[i].getText(columnIndex);
            int j = 0;
            while (j < i) {
                String value2 = items[j].getText(columnIndex);
                if (collator.compare(value1, value2) < 0) {
                    String[] values = new String[]{items[i].getText(0), items[i].getText(1)};
                    items[i].dispose();
                    TableItem item = new TableItem(table, 0, j);
                    item.setText(values);
                    items = table.getItems();
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }
}

