/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.ia.ui.TreeCell;
import java.util.LinkedList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.swt.custom.TreeCursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeSearcher
implements IFindReplaceTarget,
IFindReplaceTargetExtension3 {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Tree tree;
    private TreeCursor cursor;
    private Point defaultSelection = new Point(1, 0);
    private String findString;
    private boolean searchForward;
    private boolean caseSensitive;
    private boolean wholeWord;
    private Pattern pattern;

    public TreeSearcher(Tree tree, TreeCursor cursor) {
        this.tree = tree;
        this.cursor = cursor;
    }

    public boolean canPerformFind() {
        return false;
    }

    public int findAndSelect(int widgetOffset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
        this.searchForward = searchForward;
        this.caseSensitive = caseSensitive;
        this.wholeWord = wholeWord;
        if (this.tree != null && !this.tree.isDisposed() && this.tree.getItemCount() > 0) {
            TreeCell searchStartLocation = null;
            searchStartLocation = this.tree.getSelection().length == 0 || widgetOffset < 0 ? this.getSearchStartLocation(null) : (findString.equals(this.findString) ? this.getSearchStartLocation(new TreeCell(this.tree.getSelection()[0], this.cursor.getColumn())) : new TreeCell(this.tree.getSelection()[0], this.cursor.getColumn()));
            this.findString = findString;
            if (searchStartLocation == null) {
                return -1;
            }
            TreeCell searchResult = this.searchInsideTree(searchStartLocation);
            if (searchResult != null) {
                this.cursor.setSelection(searchResult.getTreeItem(), searchResult.getColumnIndex());
                this.tree.setSelection(searchResult.getTreeItem());
                this.tree.showItem(searchResult.getTreeItem());
                this.tree.showColumn(this.tree.getColumn(searchResult.getColumnIndex()));
                return this.defaultSelection.x;
            }
        }
        return -1;
    }

    public int findAndSelect(int offset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord, boolean regExSearch) {
        try {
            this.pattern = regExSearch ? (caseSensitive ? Pattern.compile(findString) : Pattern.compile(findString, 2)) : null;
        }
        catch (PatternSyntaxException e1) {
            return -1;
        }
        return this.findAndSelect(offset, findString, searchForward, caseSensitive, wholeWord);
    }

    public void replaceSelection(String text, boolean regExReplace) {
    }

    public Point getSelection() {
        return this.defaultSelection;
    }

    public String getSelectionText() {
        return "";
    }

    public boolean isEditable() {
        return false;
    }

    public void replaceSelection(String text) {
    }

    private boolean matchesSearchCriteria(String source) {
        if (this.caseSensitive) {
            if (this.wholeWord) {
                return source.matches(".*?\\b" + this.findString + "\\b.*?");
            }
            if (this.pattern != null) {
                return this.pattern.matcher(source).find();
            }
            return source.contains(this.findString);
        }
        if (this.wholeWord) {
            return source.toLowerCase().matches(".*?\\b" + this.findString.toLowerCase() + "\\b.*?");
        }
        if (this.pattern != null) {
            return this.pattern.matcher(source).find();
        }
        return source.toLowerCase().contains(this.findString.toLowerCase());
    }

    private TreeCell getSearchStartLocation(TreeCell location) {
        if (this.searchForward) {
            if (location == null) {
                return new TreeCell(this.tree.getItem(0), this.tree.getColumnOrder()[0]);
            }
            if (location.getColumnPosition() < this.tree.getColumnCount() - 1) {
                location.setColumnIndex(this.tree.getColumnOrder()[location.getColumnPosition() + 1]);
                return location;
            }
            if (location.getTreeItem().getItemCount() > 0) {
                location.setTreeItem(location.getTreeItem().getItem(0));
                location.setColumnIndex(this.tree.getColumnOrder()[0]);
                return location;
            }
            TreeItem item = location.getTreeItem();
            while (item.getParentItem() != null) {
                if (item.getParentItem().indexOf(item) + 1 < item.getParentItem().getItemCount()) {
                    return new TreeCell(item.getParentItem().getItem(item.getParentItem().indexOf(item) + 1), this.tree.getColumnOrder()[0]);
                }
                item = item.getParentItem();
            }
            return null;
        }
        if (location == null) {
            return new TreeCell(this.getLastLeaf(this.tree.getItem(0)), this.tree.getColumnOrder()[this.tree.getColumnCount() - 1]);
        }
        if (location.getColumnPosition() > 0) {
            location.setColumnIndex(this.tree.getColumnOrder()[location.getColumnPosition() - 1]);
            return location;
        }
        TreeItem sibling = this.getSibling(location.getTreeItem());
        if (sibling != null) {
            location.setTreeItem(this.getLastLeaf(sibling));
            location.setColumnIndex(this.tree.getColumnOrder()[this.tree.getColumnCount() - 1]);
            return location;
        }
        TreeItem parent = location.getTreeItem().getParentItem();
        if (parent != null) {
            location.setTreeItem(parent);
            location.setColumnIndex(this.tree.getColumnOrder()[this.tree.getColumnCount() - 1]);
            return location;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private TreeCell searchInsideTree(TreeCell startLocation) {
        block8: {
            visited = new LinkedList<TreeCell>();
            visited.add(startLocation);
            if (!this.searchForward) ** GOTO lbl42
            item = startLocation.getTreeItem();
            while (item.getParentItem() != null) {
                i = item.getParentItem().indexOf(item) + 1;
                while (i < item.getParentItem().getItemCount()) {
                    visited.add(new TreeCell(item.getParentItem().getItem(i), this.tree.getColumnOrder()[0]));
                    ++i;
                }
                item = item.getParentItem();
            }
            while (!visited.isEmpty()) {
                cell = (TreeCell)visited.remove();
                if (this.searchInsideTreeItem(cell) != null) {
                    return cell;
                }
                i = cell.getTreeItem().getItemCount() - 1;
                while (i >= 0) {
                    visited.addFirst(new TreeCell(cell.getTreeItem().getItem(i), this.tree.getColumnOrder()[0]));
                    --i;
                }
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                cell = (TreeCell)visited.remove();
                if (this.searchInsideTreeItem(cell) != null) {
                    return cell;
                }
                sibling = this.getSibling(cell.getTreeItem());
                if (sibling != null) {
                    cell.setTreeItem(this.getLastLeaf(sibling));
                    cell.setColumnIndex(this.tree.getColumnOrder()[this.tree.getColumnCount() - 1]);
                    visited.add(cell);
                    continue;
                }
                parent = cell.getTreeItem().getParentItem();
                if (parent == null) continue;
                cell.setTreeItem(parent);
                cell.setColumnIndex(this.tree.getColumnOrder()[this.tree.getColumnCount() - 1]);
                visited.add(cell);
lbl42:
                // 4 sources

                ** while (!visited.isEmpty())
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private TreeCell searchInsideTreeItem(TreeCell location) {
        block4: {
            i = location.getColumnPosition();
            if (!this.searchForward) ** GOTO lbl14
            while (i < this.tree.getColumnCount()) {
                if (this.matchesSearchCriteria(location.getTreeItem().getText(this.tree.getColumnOrder()[i]))) {
                    location.setColumnIndex(this.tree.getColumnOrder()[i]);
                    return location;
                }
                ++i;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                if (this.matchesSearchCriteria(location.getTreeItem().getText(this.tree.getColumnOrder()[i]))) {
                    location.setColumnIndex(this.tree.getColumnOrder()[i]);
                    return location;
                }
                --i;
lbl14:
                // 2 sources

                ** while (i >= 0)
            }
        }
        return null;
    }

    private TreeItem getSibling(TreeItem item) {
        TreeItem parent = item.getParentItem();
        if (item != null && parent != null) {
            int index = parent.indexOf(item);
            if (this.searchForward && index < parent.getItemCount() - 1) {
                return parent.getItem(index + 1);
            }
            if (!this.searchForward && index > 0) {
                return parent.getItem(index - 1);
            }
        }
        return null;
    }

    private TreeItem getLastLeaf(TreeItem parent) {
        if (parent.getItemCount() == 0) {
            return parent;
        }
        return this.getLastLeaf(parent.getItem(parent.getItemCount() - 1));
    }
}

