/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class TreeNodeFilter
extends ViewerFilter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String REGEX_METACHARS = "<([{\\^-=$!|]})?*+.>";
    private String userSearchText = "";

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        String text = element.toString();
        Pattern pattern = Pattern.compile(TreeNodeFilter.userSearchToRegex(this.userSearchText), 2);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            return true;
        }
        ITreeContentProvider provider = (ITreeContentProvider)((ContentViewer)viewer).getContentProvider();
        Object[] objectArray = provider.getChildren(element);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (this.select(viewer, element, child)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setSearchText(String text) {
        this.userSearchText = text;
    }

    private static String userSearchToRegex(String userInput) {
        StringBuffer regex = new StringBuffer();
        regex.append('^');
        int i = 0;
        while (i < userInput.length()) {
            char c = userInput.charAt(i);
            switch (c) {
                case '*': {
                    regex.append(".*");
                    break;
                }
                default: {
                    if (REGEX_METACHARS.indexOf(c) >= 0) {
                        regex.append('\\');
                    }
                    regex.append(c);
                }
            }
            ++i;
        }
        regex.append(".*");
        return regex.toString();
    }
}

