/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.SQLCommand;
import com.ibm.cics.ia.commands.AbstractFindCICSObjectType;
import com.ibm.cics.ia.ui.ExplorerQueryContext;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.ResourceExplorer;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class TransactionExplorer
extends ResourceExplorer {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String ID = "com.ibm.cics.ia.ui.transactionexplorer";
    private static final Logger logger = Logger.getLogger(TransactionExplorer.class.getPackage().getName());

    @Override
    protected SQLCommand createFindCommand(String resourceName, String criteria, ExplorerQueryContext explorerQueryContext) {
        Debug.enter((Logger)logger, (String)TransactionExplorer.class.getName(), (String)"createFindCommand", (Object[])new String[]{"ThreadId: " + Thread.currentThread().getId(), "resourceName: " + resourceName, "explorerQueryContext context label: " + explorerQueryContext.getContextLabel()});
        AbstractFindCICSObjectType result = explorerQueryContext.getTransactionFindCommand();
        result.setCriteriaName(criteria);
        result.setResourceName(resourceName);
        Debug.exit((Logger)logger, (String)TransactionExplorer.class.getName(), (String)"createFindCommand", (Object)result.getSQLString());
        return result;
    }

    @Override
    protected String getResourceTypesDescription() {
        return Messages.getString("TransactionExplorer.txt.transactions");
    }

    @Override
    protected void setHelpContextIDs(Composite aComposite) {
        IWorkbenchHelpSystem helpSystem = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)aComposite, "com.ibm.cics.ia.help.transaction_explorer");
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    @Override
    protected String getTaskName() {
        return Messages.getString("TransactionExplorer.taskname");
    }
}

