/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.AffGroup;
import com.ibm.cics.ia.model.AffinityReport;
import com.ibm.cics.ia.model.AffinityType;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.ui.AffGroupTreeViewerNode;
import com.ibm.cics.ia.ui.AffinityReportTrangroupsEditorPage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

class TrangroupTreeContentProvider
implements ITreeContentProvider {
    private AffinityReport report;
    AffGroupTreeViewerNode[] rootNodes = new AffGroupTreeViewerNode[0];
    private static final Logger logger = Logger.getLogger(TrangroupTreeContentProvider.class.getPackage().getName());

    TrangroupTreeContentProvider() {
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Debug.enter((Logger)logger, (String)AffinityReportTrangroupsEditorPage.class.getName(), (String)"inputChanged", (Object)("ThreadId: " + Thread.currentThread().getId()));
        if (newInput instanceof AffinityReport) {
            this.report = (AffinityReport)newInput;
            HashMap affTypesToBuild = new HashMap();
            List types = this.report.getAffinityTypes();
            for (AffinityType affinityType : types) {
                List affGroups = this.report.getAffinityGroups(affinityType);
                if (affGroups.size() <= 0) continue;
                ArrayList<AffGroup> groupsToBuild = new ArrayList<AffGroup>();
                for (AffGroup affGroup : affGroups) {
                    if (!"Y".equals(affGroup.getBuild())) continue;
                    groupsToBuild.add(affGroup);
                }
                if (groupsToBuild.size() <= 0) continue;
                affTypesToBuild.put(affinityType, groupsToBuild);
            }
            if (affTypesToBuild.size() == 0) {
                this.rootNodes = new AffGroupTreeViewerNode[1];
                this.rootNodes[0] = new AffGroupTreeViewerNode(AffGroupTreeViewerNode.Type.Dummy, null, null);
                Debug.exit((Logger)logger, (String)AffinityReportTrangroupsEditorPage.class.getName(), (String)"inputChanged");
                return;
            }
            this.rootNodes = new AffGroupTreeViewerNode[affTypesToBuild.size()];
            int node = 0;
            int i = 0;
            while (i < types.size()) {
                if (affTypesToBuild.get(types.get(i)) != null) {
                    this.rootNodes[node] = new AffGroupTreeViewerNode(AffGroupTreeViewerNode.Type.AffinityType, types.get(i), null);
                    List groups = (List)affTypesToBuild.get(types.get(i));
                    AffGroupTreeViewerNode[] groupNodes = new AffGroupTreeViewerNode[groups.size()];
                    this.rootNodes[node].setChildNodes(groupNodes);
                    int j = 0;
                    while (j < groups.size()) {
                        groupNodes[j] = new AffGroupTreeViewerNode(AffGroupTreeViewerNode.Type.AffGroup, groups.get(j), this.rootNodes[node]);
                        AffGroupTreeViewerNode[] transactionNodes = new AffGroupTreeViewerNode[((AffGroup)groups.get(j)).getTransactions().size()];
                        Transaction[] transactions = ((AffGroup)groups.get(j)).getTransactions().toArray(new Transaction[0]);
                        int k = 0;
                        while (k < transactions.length) {
                            transactionNodes[k] = new AffGroupTreeViewerNode(AffGroupTreeViewerNode.Type.Transaction, transactions[k], groupNodes[j]);
                            transactionNodes[k].setChildNodes(new AffGroupTreeViewerNode[0]);
                            ++k;
                        }
                        groupNodes[j].setChildNodes(transactionNodes);
                        ++j;
                    }
                    ++node;
                }
                ++i;
            }
        }
        Debug.exit((Logger)logger, (String)AffinityReportTrangroupsEditorPage.class.getName(), (String)"inputChanged");
    }

    public Object[] getElements(Object inputElement) {
        return this.rootNodes;
    }

    public Object[] getChildren(Object parentElement) {
        return ((AffGroupTreeViewerNode)parentElement).getChildNodes();
    }

    public Object getParent(Object element) {
        return ((AffGroupTreeViewerNode)element).getParentNode();
    }

    public boolean hasChildren(Object element) {
        return ((AffGroupTreeViewerNode)element).getChildNodes().length > 0;
    }
}

